#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_fw.h"

#include "BmTraceClasses.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_IF_MESSAGES
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/BmCoreIfMessage.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_IF_MESSAGES
#endif
#endif

#include "BmCoreIfMessage.h"

#ifdef VARIANT_S_FTR_ENABLE_FW_MEMORY_CHECKER
#include "FwMemoryChecker.h"
#endif

namespace bmcore
{
   unsigned int BmCoreIfMessage::_countBmCoreIfMessages = 0;

   void swap(BmCoreIfMessage& first, BmCoreIfMessage& second)
   {
      using std::swap;

      swap(first._messageId, second._messageId);
      swap(first._origin, second._origin);
      swap(first._act, second._act);
   }

   BmCoreIfMessage::BmCoreIfMessage(IN const BmCoreIfMsgId messageId, IN const FunctionalityRestrictionInfo restrictionInfo,
         IN const ActType act, IN const BmCoreIfMsgOrigin origin) :
         _messageId(messageId),
         _act(act),
         _restrictionInfo(restrictionInfo),
         _origin(origin)
   {
      ETG_TRACE_USR4(("BmCoreIfMessage: [0x%p] being created", (void*) this));

      _countBmCoreIfMessages++;

#ifdef VARIANT_S_FTR_ENABLE_FW_MEMORY_CHECKER
      FW_MEMORY_CHECK_NEW_OBJ(this);
#endif
   }

   BmCoreIfMessage::BmCoreIfMessage(IN const BmCoreIfMessage& other) :
         _messageId(other._messageId),
         _act(other._act),
         _restrictionInfo(other._restrictionInfo),
         _origin(other._origin)
   {
      ETG_TRACE_USR4(("BmCoreIfMessage: [0x%p] being copy-created", (void*) this));
      _countBmCoreIfMessages++;

#ifdef VARIANT_S_FTR_ENABLE_FW_MEMORY_CHECKER
      FW_MEMORY_CHECK_NEW_OBJ(this);
#endif
   }

   BmCoreIfMessage::~BmCoreIfMessage()
   {
      ETG_TRACE_USR4(("~BmCoreIfMessage: [0x%p] being destroyed", (void*) this));

      if (_countBmCoreIfMessages)
      {
         _countBmCoreIfMessages--;
      }

#ifdef VARIANT_S_FTR_ENABLE_FW_MEMORY_CHECKER
      FW_MEMORY_CHECK_DEL_OBJ(this);
#endif
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   BmCoreIfMessage& BmCoreIfMessage::operator=(BmCoreIfMessage other)
   {
      swap(*this, other);

      return *this;
   }

   bool BmCoreIfMessage::operator==(const BmCoreIfMessage& rhs) const
   {
      return ((this->_messageId == rhs._messageId)
            && (this->_restrictionInfo == rhs._restrictionInfo)
            && (this->_act == rhs._act)
            && (this->_origin == rhs._origin));
   }

   void BmCoreIfMessage::traceMessage(void) const
   {
      ETG_TRACE_USR4(("traceMessage: [0x%p] msgId = %d, restrictionInfo = %50s, act = %u, origin = %d",
            (const void*) this, ETG_CENUM(BmCoreIfMsgId, _messageId), _restrictionInfo.to_string().c_str(),
            _act, ETG_CENUM(BmCoreIfMsgOrigin, _origin)));
   }
}
