//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

// This header exists to guarantee backwards compatibility of compile switches for CGI-Studio Candera V3.0.0

#if !defined(CANDERA_DEPRECATED_H)
    #define CANDERA_DEPRECATED_H

#if defined(_MSC_VER)
    #define _CANDERA_WARNING(msg) \
        __pragma(message(msg))
#elif defined(__GNUC__) || defined(__MINGW32__) || defined(__ghs__)
    #define _DO_PRAGMA(msg) _Pragma ( #msg )
    #define _CANDERA_WARNING(msg) \
    _DO_PRAGMA(message msg)
#else 
    #define _CANDERA_WARNING(msg) ;
#endif

/// @addtogroup Config
/// @{

#define RENDER_STATE_CACHE_ENABLED
#if defined(RENDER_STATE_CACHE_ENABLED) && !defined(CANDERA_RENDER_STATE_CACHING_ENABLED)
    #define CANDERA_RENDER_STATE_CACHING_ENABLED
    _CANDERA_WARNING("WARNING: Use of RENDER_STATE_CACHE_ENABLED is deprecated, use CANDERA_RENDER_STATE_CACHING_ENABLED instead")
#endif

/* #undef CANDERA_DEVICE_4BIT_GLYPH_CACHE_ENABLED */
#if defined(CANDERA_DEVICE_4BIT_GLYPH_CACHE_ENABLED) && !defined(CANDERA_4BIT_GLYPH_CACHE_ENABLED)
    #define CANDERA_4BIT_GLYPH_CACHE_ENABLED
    _CANDERA_WARNING("WARNING: Use of CANDERA_DEVICE_4BIT_GLYPH_CACHE_ENABLED is deprecated, use CANDERA_4BIT_GLYPH_CACHE_ENABLED instead")
#endif

/* #undef CANDERA_SYSTEM_MEMORY_STATISTIC_ENABLED */
#if defined(CANDERA_SYSTEM_MEMORY_STATISTIC_ENABLED) && !defined(FEATSTD_SYSTEM_MEMORY_STATISTIC_ENABLED)
    #define FEATSTD_SYSTEM_MEMORY_STATISTIC_ENABLED
    _CANDERA_WARNING("WARNING: Use of CANDERA_SYSTEM_MEMORY_STATISTIC_ENABLED is deprecated, use FEATSTD_SYSTEM_MEMORY_STATISTIC_ENABLED instead")
#endif

/* #undef CANDERA_SYSTEM_MEMORY_STATISTIC_FILE_AND_LINE_TRACKING */
#if defined(CANDERA_SYSTEM_MEMORY_STATISTIC_FILE_AND_LINE_TRACKING) && !defined(FEATSTD_SYSTEM_MEMORY_STATISTIC_FILE_AND_LINE_TRACKING_ENABLED)
    #define FEATSTD_SYSTEM_MEMORY_STATISTIC_FILE_AND_LINE_TRACKING_ENABLED
    _CANDERA_WARNING("WARNING: Use of CANDERA_SYSTEM_MEMORY_STATISTIC_FILE_AND_LINE_TRACKING is deprecated, use FEATSTD_SYSTEM_MEMORY_STATISTIC_FILE_AND_LINE_TRACKING_ENABLED instead")
#endif

/* #undef CANDERA_SYSTEM_VIDEO_STATISTIC_ENABLED */
#if defined(CANDERA_SYSTEM_VIDEO_STATISTIC_ENABLED) && !defined(CANDERA_VIDEO_MEMORY_STATISTIC_ENABLED)
    #define CANDERA_VIDEO_MEMORY_STATISTIC_ENABLED
    _CANDERA_WARNING("WARNING: Use of CANDERA_SYSTEM_VIDEO_STATISTIC_ENABLED is deprecated, use CANDERA_VIDEO_MEMORY_STATISTIC_ENABLED instead")
#endif

#define CANDERA_LOG_ENABLED
#if defined(CANDERA_LOG_ENABLED) && !defined(FEATSTD_LOG_ENABLED)
    #define FEATSTD_LOG_ENABLED
    _CANDERA_WARNING("WARNING: Use of CANDERA_LOG_ENABLED is deprecated, use FEATSTD_LOG_ENABLED instead")
#endif

#define CANDERA_2D_LAYOUTING_ENABLED
#if defined(CANDERA_2D_LAYOUTING_ENABLED) && !defined(CANDERA_LAYOUT_ENABLED)
    #define CANDERA_LAYOUT_ENABLED
    _CANDERA_WARNING("WARNING: Use of CANDERA_2D_LAYOUTING_ENABLED is deprecated, use CANDERA_LAYOUT_ENABLED instead")
#endif

/* #undef CANDERA_MONITOR_ENABLED */
#if defined(CANDERA_MONITOR_ENABLED) && !defined(FEATSTD_MONITOR_ENABLED)
    #define FEATSTD_MONITOR_ENABLED
    _CANDERA_WARNING("WARNING: Use of CANDERA_MONITOR_ENABLED is deprecated, use FEATSTD_MONITOR_ENABLED instead")
#endif

#ifdef FEATSTD_MONITOR_ENABLED

/* #undef CANDERA_DISABLE_PERFORMANCE_RECORDER */
//Inverted logic needs inverted define
#if defined(CANDERA_DISABLE_PERFORMANCE_RECORDER) 
#undef CANDERA_DISABLE_PERFORMANCE_RECORDER
#else
#define CANDERA_DISABLE_PERFORMANCE_RECORDER
#endif

#if !defined(CANDERA_DISABLE_PERFORMANCE_RECORDER) && !defined(MONITOR_CANDERA_PERFORMANCE_RECORDER_ENABLED)
    #define  MONITOR_CANDERA_PERFORMANCE_RECORDER_ENABLED
    _CANDERA_WARNING("WARNING: Use of CANDERA_DISABLE_PERFORMANCE_RECORDER is deprecated, use MONITOR_CANDERA_PERFORMANCE_RECORDER_ENABLED instead")
#endif
#if defined(CANDERA_DISABLE_PERFORMANCE_RECORDER) && defined(MONITOR_CANDERA_PERFORMANCE_RECORDER_ENABLED)
    #undef CANDERA_DISABLE_PERFORMANCE_RECORDER
#endif

/* #undef CANDERA_PERFORMANCE_RECORDER_DISABLED */
//Inverted logic needs inverted define
#if defined(CANDERA_PERFORMANCE_RECORDER_DISABLED) 
#undef CANDERA_PERFORMANCE_RECORDER_DISABLED
#else
#define CANDERA_PERFORMANCE_RECORDER_DISABLED
#endif

#if !defined(CANDERA_PERFORMANCE_RECORDER_DISABLED) && !defined(MONITOR_CANDERA_PERFORMANCE_RECORDER_ENABLED)
    #define  MONITOR_CANDERA_PERFORMANCE_RECORDER_ENABLED
    _CANDERA_WARNING("WARNING: Use of CANDERA_PERFORMANCE_RECORDER_DISABLED is deprecated, use MONITOR_CANDERA_PERFORMANCE_RECORDER_ENABLED instead")
#endif
#if defined(CANDERA_PERFORMANCE_RECORDER_DISABLED) && defined(MONITOR_CANDERA_PERFORMANCE_RECORDER_ENABLED)
    #undef CANDERA_PERFORMANCE_RECORDER_DISABLED
#endif


/* #undef CANDERA_MONITOR_CUSTOM_EXPERIMENTS */
#if defined(CANDERA_MONITOR_CUSTOM_EXPERIMENTS) && !defined(MONITOR_CANDERA_CUSTOM_EXPERIMENTS)
    #define MONITOR_CANDERA_CUSTOM_EXPERIMENTS
    _CANDERA_WARNING("WARNING: Use of CANDERA_MONITOR_CUSTOM_EXPERIMENTS is deprecated, use MONITOR_CANDERA_CUSTOM_EXPERIMENTS instead")
#endif


#endif
/// @}

#endif  // CANDERA_DEPRECATED_H
