//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(FeatStd_Utils_WarningMacros_h)
#define FeatStd_Utils_WarningMacros_h

#ifndef FeatStd_Config_h
    #error Please include <FeatStd/Config.h> before this file!
#endif

/// @addtogroup FEATSTD_UTILS
/// @{
/******************************************************************************
 *  Macros to suppress Microsoft compiler warnings (MSC)
 *
 *  usage:
 *  FEATSTD_SUPPRESS_MSC_WARNING_FOR_NEXT_EXPRESSION(4127, while (false) accepted)
 ******************************************************************************/

#if defined(_MSC_VER)
#define FEATSTD_SUPPRESS_MSC_WARNING_FOR_NEXT_EXPRESSION(message_number, reason) \
    __pragma(warning(suppress:message_number))
#else
#define FEATSTD_SUPPRESS_MSC_WARNING_FOR_NEXT_EXPRESSION(message_number, reason)
#endif

#if defined(_MSC_VER)
#define FEATSTD_PRAGMA(x) __pragma(x)

    /** ignore given warning with MSC. 
        must be terminated by FEATSTD_SUPPRESS_MSC_WARNING_END. Nesting
        is allowed. 
        @param warning warning number 
        @param reason reason for warning deactivation */
    #define FEATSTD_SUPPRESS_MSC_WARNING_BEGIN(warning_number, reason) \
        FEATSTD_PRAGMA(warning(push)) \
        FEATSTD_PRAGMA(warning(disable:warning_number))

    /** ends suppression of warning specified in FEATSTD_SUPPRESS_MULTI_WARNING_BEGIN */
    #define FEATSTD_SUPPRESS_MSC_WARNING_END() \
        FEATSTD_PRAGMA(warning(pop))
#else
    #define FEATSTD_SUPPRESS_MSC_WARNING_BEGIN(warning, reason)
    #define FEATSTD_SUPPRESS_MSC_WARNING_END()
#endif
/******************************************************************************
 *  Macros to suppress Greenhills Multi
 ******************************************************************************/
#if defined(__ghs__)
    #define FEATSTD_PRAGMA(x) _Pragma(#x)

    /** ignore given warning with MULTI tool chain. 
        must be terminated by FEATSTD_SUPPRESS_MULTI_WARNING_END. Nesting
        is allowed. 
        @param warning warning number 
        @param reason reason for warning deactivation */
    #define FEATSTD_SUPPRESS_MULTI_WARNING_BEGIN(warning, reason) \
        FEATSTD_PRAGMA(ghs nowarning warning)

    /** ends suppression of warning specified in FEATSTD_SUPPRESS_MULTI_WARNING_BEGIN */
    #define FEATSTD_SUPPRESS_MULTI_WARNING_END() \
        FEATSTD_PRAGMA(ghs endnowarning)
#else
    #define FEATSTD_SUPPRESS_MULTI_WARNING_BEGIN(warning, reason)
    #define FEATSTD_SUPPRESS_MULTI_WARNING_END()
#endif

/******************************************************************************
*  Macros to suppress IAR
******************************************************************************/
#if defined(__IAR_SYSTEMS_ICC__)
    #define FEATSTD_PRAGMA(x) _Pragma(#x)

/** ignore given warning with IAR tool chain. 
must be terminated by FEATSTD_SUPPRESS_MULTI_WARNING_END. Nesting
is allowed. 
@param warning_number warning number 
@param reason reason for warning deactivation */
#define FEATSTD_SUPPRESS_IAR_WARNING_BEGIN(warning_number, reason) \
    FEATSTD_PRAGMA(diag_suppress=warning_number)

/** ends suppression of warning specified in FEATSTD_SUPPRESS_IAR_WARNING_BEGIN */
#define FEATSTD_SUPPRESS_IAR_WARNING_END(warning_number) \
    FEATSTD_PRAGMA(diag_default=warning_number)
#else
#define FEATSTD_SUPPRESS_IAR_WARNING_BEGIN(warning_number, reason)
#define FEATSTD_SUPPRESS_IAR_WARNING_END(warning_number)
#endif
/******************************************************************************
 *  Macros to suppress GCC warnings
 ******************************************************************************/
#if defined(__GNUC__) || defined(__MINGW32__)
    #define FEATSTD_PRAGMA(x) _Pragma(#x)

    /** ignore given warning with GCC. 
        must be terminated by FEATSTD_SUPPRESS_GCC_WARNING_END. Nesting
        is allowed. 
        @param warning warning_category category enclosed by '"' - to determine the category for a warning, build with option -fdiagnostics-show-option 
        @param reason reason for warning deactivation */
#if defined(__GNUC__) && (__GNUC__ > 4 || (__GNUC__ == 4 && __GNUC_MINOR__ >= 8))
    #define FEATSTD_SUPPRESS_GCC_WARNING_BEGIN(warning_category, reason) \
        FEATSTD_PRAGMA(GCC diagnostic push) \
        FEATSTD_PRAGMA(GCC diagnostic ignored warning_category)
#else
#define FEATSTD_SUPPRESS_GCC_WARNING_BEGIN(warning_category, reason) \
    FEATSTD_PRAGMA(GCC diagnostic ignored warning_category)
#endif
    /** ends suppression of warning specified in FEATSTD_SUPPRESS_MULTI_WARNING_BEGIN */
#if defined(__GNUC__) && (__GNUC__ > 4 || (__GNUC__ == 4 && __GNUC_MINOR__ >= 8))
    #define FEATSTD_SUPPRESS_GCC_WARNING_END() \
        FEATSTD_PRAGMA(GCC diagnostic pop)
#else
    #define FEATSTD_SUPPRESS_GCC_WARNING_END()
#endif
#else
    #define FEATSTD_SUPPRESS_GCC_WARNING_BEGIN(warning_category, reason)
    #define FEATSTD_SUPPRESS_GCC_WARNING_END()
#endif

/******************************************************************************
 *  Macros to suppress deprecations warnings
 ******************************************************************************/
#define FEATSTD_SUPPRESS_DEPRECATION_WARNING_BEGIN() \
    FEATSTD_SUPPRESS_GCC_WARNING_BEGIN("-Wdeprecated-declarations", "Ignore deprecation") \
    FEATSTD_SUPPRESS_MSC_WARNING_BEGIN(4995,"Ignore deprecation") \
    FEATSTD_SUPPRESS_MSC_WARNING_BEGIN(4996, "Ignore deprecation") \
    FEATSTD_SUPPRESS_IAR_WARNING_BEGIN(Pe1215, "Ignore deprecation") \
    FEATSTD_SUPPRESS_MULTI_WARNING_BEGIN(1215, "Ignore deprecation")

#define FEATSTD_SUPPRESS_DEPRECATION_WARNING_END() \
    FEATSTD_SUPPRESS_GCC_WARNING_END() \
    FEATSTD_SUPPRESS_MSC_WARNING_END() \
    FEATSTD_SUPPRESS_MSC_WARNING_END() \
    FEATSTD_SUPPRESS_IAR_WARNING_END(Pe1215) \
    FEATSTD_SUPPRESS_MULTI_WARNING_END()

/******************************************************************************
 *  Macros to suppress Lint warnings
 ******************************************************************************/

/// Sole functionality of the class is executed in constructor/destructor.
#define FEATSTD_LINT_CTORDTOR_EFFECT(classname) /*lint -esym(1788, classname)*/

/// Contructor declard private because class implements singleton pattern.
#define FEATSTD_LINT_SINGLETON(classname) /*lint -esym(1704, classname)*/

/// 1566: Class members not initialized in constructor but in function symbol.
#define FEATSTD_LINT_INITIALIZER_FUNCTION(symbol) /*lint -sem(symbol, initializer)*/

/// 1579: Class members not freed in destructor but in function symbol.
#define FEATSTD_LINT_CLEANUP_FUNCTION(symbol) /*lint -sem(symbol, cleanup)*/

/// 1762: Method shouldn't be const because "reason".
#define FEATSTD_LINT_NONCONST_METHOD(symbol, reason) /*lint --esym(1762, symbol)*/

///  534: Ignoring return value of function is without problems.
#define FEATSTD_LINT_IGNORE_RETURN_VALUE(symbol) /*lint -esym(534, symbol)*/

/// do ... while (false) favored
#define FEATSTD_LINT_MACRO_WHILEFALSE(macroname) /*lint -emacro(717, macroname)*/

/// Suppress message_number for macroname.
#define FEATSTD_LINT_MACRO(message_number, macroname, reason) /*lint -emacro(message_number, macroname)*/

/// Suppress message_number for file.
#define FEATSTD_LINT_FILE(message_number, filename, reason) /*lint -efile(message_number, filename)*/

/// Suppress message_number for symbol.
#define FEATSTD_LINT_SYMBOL(message_number, symbol, reason) /*lint -esym(message_number, symbol)*/

/// Suppress message_number in current scope >{}<.
#define FEATSTD_LINT_CURRENT_SCOPE(message_number, reason) /*lint --e{message_number}*/

/// Suppress message_number for next expression.
#define FEATSTD_LINT_NEXT_EXPRESSION(message_number, reason) /*lint --e(message_number)*/

#define FEATSTD_LINT_MESSAGE_STRING(message_number, string, reason) /*lint -estring(message_number, string)*/

/// Suppress message_number for next expression.
#define FEATSTD_LINT_POSSIBLE_USE_OF_NULL_POINTER(reason) /*lint --e(613)*/

// Fall through
#define FEATSTD_LINT_FALLTHROUGH(reason) /*lint --e{1960} -fallthrough */

/// 1927
#define FEATSTD_LINT_MEMBER_INIT_IN_CTOR_BODY(symbol) FEATSTD_LINT_SYMBOL(1927, symbol, "member is not in ctor initializer list, but is initalized before first read in ctor body")

/// 586 - operator new is deprecated
#define FEATSTD_LINT_DYNAMIC_MEMORY() FEATSTD_LINT_NEXT_EXPRESSION(586, "CGI Studio product requirements demand dynamic memory allocations. Thus dynamic memory allocations are allowed as long correct error handling applies.")

/** To access the type of an object at run-time in a unique way, a static method
with fixed name "GetTypeId" is provided by every derived class in a class hierarchy. */
#define FEATSTD_LINT_REASON_RTTI

/// @}
#endif
