//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include <FeatStd/Util/ValidationHelperBase.h>
#include <FeatStd/Platform/CriticalSection.h>
#include <FeatStd/Platform/CriticalSectionLocker.h>


namespace FeatStd{
    
    void ValidationHelperBase::SetInvalid()
    {
#ifdef FEATSTD_THREADSAFETY_ENABLED
        FeatStd::Internal::CriticalSectionLocker lock(&m_lock);
#endif
        SetInvalidImplementation();
    }

    void ValidationHelperBase::SetValid()
    {
#ifdef FEATSTD_THREADSAFETY_ENABLED
        FeatStd::Internal::CriticalSectionLocker lock(&m_lock);
#endif
        SetValidImplementation();
    }

    bool ValidationHelperBase::IsValid() const
    {
#ifdef FEATSTD_THREADSAFETY_ENABLED
        FeatStd::Internal::CriticalSectionLocker lock(&m_lock);
#endif
        return IsValidImplementation();
    }

    void ValidationHelperBase::Reset()
    {
#ifdef FEATSTD_THREADSAFETY_ENABLED
        FeatStd::Internal::CriticalSectionLocker lock(&m_lock);
#endif
        ResetImplementation();
    }

    void ValidationHelperBase::ConfirmValidHandled()
    {
#ifdef FEATSTD_THREADSAFETY_ENABLED
        FeatStd::Internal::CriticalSectionLocker lock(&m_lock);
#endif
        ConfirmValidHandledImplementation();
    }

    ValidationHelperBase::ValidationHelperBase()
    {

    }

}
