//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(FeatStd_Util_TextId_h)
#define FeatStd_Util_TextId_h

#include <FeatStd/Base.h>

namespace FeatStd { 

/// @addtogroup FEATSTD_UTILS
/// @{

    /**
     * TextId class to access translatable texts.
     */
    class TextId {
    public:
        /**
         * TextId constructor based on a character id.
         */
        explicit TextId(const Char* strId);

        /**
         * @return computed hash value for the character id.
         */
        SizeType GetHashValue() const { return m_hash; }

        /**
         * Equals operator
         */
        bool operator==(const TextId & other) const {
            return other.m_hash == m_hash;
        }
        /**
         * Not-equals operator
         */
        bool operator!=(const TextId & other) const {
            return other.m_hash != m_hash;
        }
    private:
        SizeType m_hash;
    };
/// @}
}

#endif // !defined(FeatStd_Util_TextId_h)
