//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(FEATSTD_STRING_STRINGFACTORY_H)
    #define FEATSTD_STRING_STRINGFACTORY_H

#include <FeatStd/Base.h>

FEATSTD_UNIT_TEST_TESTCASE_DECLARATION(StringData, StringDataFactory)

namespace FeatStd { namespace Internal {
/// @addtogroup FEATSTD_UTILS
/// @{
    class StringDataBase;

    class StringDataFactory {
        static const UInt8 cPriority = 1;

        public:
            virtual ~StringDataFactory() {}

            static StringDataFactory& GetInstance();

            virtual StringDataBase* CreateLocalizableStringData(SizeType id) const {
                return CreateLocalizableStringData(id,0);
            }

            virtual StringDataBase* CreateLocalizableStringData(SizeType id, const TChar* defaultString) const;

        protected:
            // implemented as singleton
            StringDataFactory(UInt8 priority);

        private:
            static StringDataFactory*& GetRegisteredStringFactory();
            static UInt8& GetRegisteredPrio();

            void RegisterFactory(StringDataFactory* factory, UInt8 priority) const;
            FEATSTD_UNIT_TEST_TESTCASE_FRIEND(StringData, StringDataFactory);
   };
/// @}
}}
#endif  // FEATSTD_STRING_STRINGFACTORY_H
