//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include <FeatStd/Util/StaticObject.h>
#include "StringDataFactory.h"

namespace FeatStd { namespace Internal {
/******************************************************************************
 *  GetInstance
 ******************************************************************************/
StringDataFactory& StringDataFactory::GetInstance()
{
    FEATSTD_UNSYNCED_STATIC_OBJECT(StringDataFactory, s_stringFactory, cPriority);
    FEATSTD_UNUSED(s_stringFactory);
    return *GetRegisteredStringFactory();
}

static StringDataFactory& s_forceInitStringDataFactory = StringDataFactory::GetInstance();

/******************************************************************************
 *  Constructor
 ******************************************************************************/
StringDataFactory::StringDataFactory(UInt8 priority)
{
    StringDataFactory::RegisterFactory(this, priority);
}

/******************************************************************************
 *  CreateLocalizableStringData
 ******************************************************************************/
StringDataBase* StringDataFactory::CreateLocalizableStringData(SizeType /*id*/, const TChar* /* defaultString = 0 */) const
{
    return 0;
}

/******************************************************************************
 *  GetRegisteredStringFactory
 ******************************************************************************/
StringDataFactory*& StringDataFactory::GetRegisteredStringFactory()
{
    static StringDataFactory* s_registeredStringFactory = 0;
    return s_registeredStringFactory;
}

/******************************************************************************
 *  GetRegisteredPrio
 ******************************************************************************/
UInt8& StringDataFactory::GetRegisteredPrio()
{
    static UInt8 s_registeredPrio = 0;
    return s_registeredPrio;
}

/******************************************************************************
 *  RegisterFactory
 ******************************************************************************/
void StringDataFactory::RegisterFactory(StringDataFactory* factory, UInt8 priority) const
{
    StringDataFactory*& registeredFactory = GetRegisteredStringFactory();
    UInt8& registeredPrio = GetRegisteredPrio();

    if ((factory != 0) && ((registeredFactory == 0) || (registeredPrio < priority)))
    {
        registeredFactory = factory;
        registeredPrio = priority;
    }
}
}}   // namespace FeatStd::Internal
