//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "Random.h"

namespace FeatStd
{

Random::Random(UInt32 seed)
{
    Init(seed);
}

UInt32 Random::Get()
{
    UInt64 c = 2111111111 * mX[3] + 1492 * mX[2] + 1776 * mX[1] + 5115 * mX[0] + mX[4];

    mX[4] = (c >> 32) & 0xFFFFFFFF;
    mX[3] = mX[2];
    mX[2] = mX[1];
    mX[1] = mX[0];
    mX[0] = c & 0xFFFFFFFF;

    return static_cast<UInt32>(mX[0]);
}

void Random::Init(UInt32 seed)
{
    UInt32 s = seed;

    // initialize the buffer based on the seed
    for (UInt32 i = 0; i < 5; i++)
    {
        s = s * 29943829 - 1;
        mX[i] = s;
    }

    // randomize the buffer
    for (UInt32 i = 0; i < 19; i++)
    {
        static_cast<void>(Get());
    }
}

}
