//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(FeatStd_Utils_PrePHelperMacros_h)
#define FeatStd_Utils_PrePHelperMacros_h

#ifndef FeatStd_Config_h
    #error Please include <FeatStd/Config.h> before this file!
#endif

#include <FeatStd/Util/WarningMacros.h>

/// @addtogroup FEATSTD_UTILS
/// @{
/******************************************************************************
 *  Macros to support macro writing
 ******************************************************************************/

/** Support macro for macro FEATSTD_CONCAT2 */
#define _FEATSTD_CONCAT2_SUPP(x, y) x##y

/** Concatenates given identifiers to a single identifier
    uses C preprocessor ## operator to concatenate x and y */
#define FEATSTD_CONCAT2(x, y) _FEATSTD_CONCAT2_SUPP(x, y)

/** Concatenates given identifiers to a single identifier
    uses C preprocessor ## operator to concatenate x, y, and z */
#define FEATSTD_CONCAT3(x, y, z) FEATSTD_CONCAT2(FEATSTD_CONCAT2(x, y), z)

/** Support macro for FEATSTD_STRINGIZE */
#define _FEATSTD_STRINGIZE_SUPP(x) #x

/** Stringize given parameter using C preprocessor # operator */
#define FEATSTD_STRINGIZE(x) _FEATSTD_STRINGIZE_SUPP(x)

/** Preprocessor macro parameter helper
    some odd cases require passing statements with that contain commas to preprocessor macros.
    in that case the parser of the preprocessor misinterprets the comma as separator for
    macro paramters. FEATSTD_COMMA can be used to handle this situations.
    @param x the expression left to the comma
    @param y the expression right to the comma

    @code
    template<typename T1, typename T2> struct Foo {
        ...
    };

    #define MY_TYPEDEF_MACRO(type, name) typedef type name;
    ...

    MY_TYPEDEF_MACRO(Foo<int, int>, Bar); // causes preprocessor error - too many macro arguments
    MY_TYPEDEF_MACRO(Foo<FEATSTD_COMMA(int, int)>, Bar); // works
    @endcode
    */
#define FEATSTD_COMMA(x, y) x, y


/** can be used to define complex arguments to macros
    macro arguments which include commas (like template types e.g. FOO(MyTemplate<X, Y>) require
    special handling. the comma will be parsed as macro argument separator otherwise. 
    @code
    template<typename T1, typename T2> struct Foo {
    ...
    };

    #define MY_TYPEDEF_MACRO(type, name) typedef type name;
    ...

    MY_TYPEDEF_MACRO(Foo<int, int>, Bar); // causes preprocessor error - too many macro arguments
    MY_TYPEDEF_MACRO(FEATSTD_ARG(Foo<int, int>), Bar); // works
    @endcode
    */
#define FEATSTD_ARG(...) __VA_ARGS__


/** \def FEATSTD_EXPAND_TO_VOID
    \brief use this macro to let a macro expand to void (nothing). 
    the macro suppresses Microsoft Visual Studio warning "while(false) expected */
FEATSTD_LINT_MACRO_WHILEFALSE(FEATSTD_EXPAND_TO_VOID)
#define FEATSTD_EXPAND_TO_VOID() \
        FEATSTD_SUPPRESS_MSC_WARNING_FOR_NEXT_EXPRESSION(4127, "while (false) accepted") \
        do { } while(false)

/// @}
#endif
