//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include <FeatStd/Util/DefaultValidationHelper.h>
namespace FeatStd{
    void FeatStd::DefaultValidationHelper::ResetImplementation()
    {
        m_nodeCount = 0;
    }

    DefaultValidationHelper::DefaultValidationHelper() :m_nodeCount(0){}

    void DefaultValidationHelper::SetInvalidImplementation()
    {
        m_nodeCount++;
    }

    void DefaultValidationHelper::SetValidImplementation()
    {
        if (m_nodeCount == 0)
        {
            // Probably not intended
            // FEATSTD_DEBUG_ASSERT(false);
            return;
        }
        m_nodeCount--;
    }

    bool DefaultValidationHelper::IsValidImplementation() const
    {
        return m_nodeCount == 0;
    }

    void DefaultValidationHelper::ConfirmValidHandledImplementation()
    {
        // the default validation helper is a simple counter 
        // it is not interested in an acknowledgment of valid state
    }

}
