//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(FeatStd_Platform_Types_h)
#define FeatStd_Platform_Types_h

#include <FeatStd/Platform/PlatformInclude.h>
#include <FeatStd/Platform/FractionalNumber.h>

namespace FeatStd { namespace CharacterEncodingScheme {
/// @addtogroup FEATSTD_PLATFORM
/// @{
        /** Character encoding scheme
            Specifies in combination with TChar data type the encoding of multi lingual strings */
        enum Enum {
            UTF8,               ///< string is encoded in UTF-8
            UTF16,              ///< string is are encoded in UTF-16
            UTF32,              ///< string is are encoded in UTF-32

            ASCII,              ///< string is are encoded in plain ASCII
            UCS2,               ///< string is are encoded in fixed length UCS2
            UCS4 = UTF32        ///< string is are encoded in
        };
/// @}
}}

#include FEATSTD_PLATFORM_INCLUDE(Types)

namespace FeatStd { namespace TypeSystem {
/// @addtogroup FEATSTD_PLATFORM
/// @{

    /** Character data type.
        Char data stores a single 8 bit character. */
    using Internal::Impl::Types::Char;

    /** UCS2 data type. */
    using Internal::Impl::Types::Ucs2Char;

    /** Character type for I18N text */
    using Internal::Impl::Types::TChar;

    /** Defines the encoding of TChar strings */
    using Internal::Impl::Types::TCharEncodingScheme;

    /** Defines the encoding of TChar is UTF */
    using Internal::Impl::Types::TCharIsUtfEncoded;

    /** Integer data type.
        Int data stores signed integral data with architecture dependent bit size.
        Int shall at least store 16 bit data. */
    using Internal::Impl::Types::Int;

    /** Unsigned integer data type.
        UInt data stores unsigned integral data with architecture dependent bit size.
        UInt shall at least store 16 bit data.
        The return value of the sizeof() operator (std::size_t) is implementation defined and not to be confused with UInt. */
    using Internal::Impl::Types::UInt;

    /** 8bit signed integer data type.
        Int8 data stores signed 8 bit integral data. */
    using Internal::Impl::Types::Int8;

    /** 8bit unsigned integer data type.
        UInt8 data stores unsigned 8 bit integral data. */
    using Internal::Impl::Types::UInt8;

    /** 16bit signed integer data type.
        Int16 data stores signed 16 bit integral data. */
    using Internal::Impl::Types::Int16;

    /** 16bit unsigned integer data type.
        UInt16 data stores unsigned 16 bit integral data. */
    using Internal::Impl::Types::UInt16;

    /** 32bit signed integer data type.
        Int32 data stores signed 32 bit integral data. */
    using Internal::Impl::Types::Int32;

    /** 32bit unsigned integer data type.
        UInt32 data stores signed 32 bit integral data. */
    using Internal::Impl::Types::UInt32;

    /** 64bit signed integer data type.
        Int64 data stores signed 64 bit integral data. */
    using Internal::Impl::Types::Int64;

    /** 64bit unsigned integer data type.
        UInt64 data stores unsigned 64 bit integral data. */
    using Internal::Impl::Types::UInt64;

    /** Floating point data type.
        Float stores floating point data with 32 bits. */
#if defined(FEATSTD_FIXED_POINT_ARITHMETIC)
    using FractionalNumber::Float;
#else
    using Internal::Impl::Types::Float;
#endif

    /** Double precision data type.
        Double stores floating point data with 64 bits. */
    using Internal::Impl::Types::Double;

    /** Handle data type.
        Handle stores address data with 32/64 bits, depending on the platform. */
#ifdef FEATSTD_64BIT_PLATFORM
    typedef UInt64 Handle;
#elif defined(FEATSTD_32BIT_PLATFORM)
    typedef UInt32 Handle;
#else 
#error 64 bit macro error
#endif

    /** Type for C/C++ bit field declarations */
    using Internal::Impl::Types::BitField;

    /** std::size_t type */
    using Internal::Impl::Types::SizeType;

    /** std::ptrdiff_t type */
    using Internal::Impl::Types::OffsetType;

    using namespace Internal::Impl::Limits;
/// @}
}}

namespace FeatStd {
    using namespace FeatStd::TypeSystem;
}

#endif
