//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(FeatStd_Platform_Posix_PosixTicks_h)
#define FeatStd_Platform_Posix_PosixTicks_h

#include <FeatStd/Platform/Base.h>
#include <FeatStd/Platform/TickValue.h>

namespace FeatStd { namespace Internal { namespace Posix {
    /// @addtogroup FEATSTD_PLATFORM_POSIX
    /// @{
    /** Posix inplementation for Ticks. */
    class PosixTicks {
    public:
        /** Returns <em>now</em> based on the system startup time.
            @return     <em>Now</em> in ticks */
        static TickValue GetSystemTicks();

        /** Returns <em>infinite</em> time represented in ticks.
            @return     <em>Infinite</em> in ticks */
        static TickValue Infinite();

        /** Converts time (in milliseconds) into ticks.
            @param theTime     Time to convert in milliseconds.
            @return         Converted ticks. */
        static TickValue Time2Ticks(UInt32 theTime);

        /** Converts ticks into time (in milliseconds).
            @param ticks    Ticks to convert.
            @return         Converted time in milliseconds. */
        static UInt32 Ticks2Time(TickValue ticks);
    };
    /// @}
}}}

namespace FeatStd { namespace Internal { namespace Impl {
    typedef FeatStd::Internal::Posix::PosixTicks Ticks;
}}}

#endif
