//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "PosixThreadLocalPointer.h"

namespace FeatStd { namespace Internal { namespace Posix {

    FEATSTD_LOG_SET_REALM(FeatStd::Diagnostics::LogRealm::FeatStdPlatform);

FEATSTD_LINT_CURRENT_SCOPE(1401, "Violates MISRA C++ 2008 Required Rule 8-5-1: false positive, not initialized is wrong")   
FEATSTD_LINT_CURRENT_SCOPE(1960, "Violates MISRA C++ 2008 Required Rule 5-18-1: false positive, comma operator is not used")
FEATSTD_LINT_CURRENT_SCOPE(774, "Violates MISRA C++ 2008 Required Rule 0-1-2: false positive as wrongly identified as comma operator")
FEATSTD_LINT_CURRENT_SCOPE(948, "Violates MISRA C++ 2008 Required Rule 0-1-9: false positive as wrongly identified as comma operator")
FEATSTD_LINT_CURRENT_SCOPE(944, "Violates MISRA C++ 2008 Required Rule 0-1-1: false positive as wrongly identified as comma operator")
        
PosixThreadLocalPointer::PosixThreadLocalPointer(void)
{
    Int success = static_cast<Int>(::pthread_key_create(&m_tlsIndex, 0));
    m_valid = (0 == success);
    if (!m_valid) {
        FEATSTD_LOG_ERROR("Unable to allocate key for thread-local storage.");
    }
}

PosixThreadLocalPointer::~PosixThreadLocalPointer(void)
{
    FEATSTD_LINT_SYMBOL(1740, FeatStd::Internal::Posix::PosixThreadLocalPointer::m_tlsIndex, "False positive, member is freed by destructor")   
    if (IsValid()) {
        static_cast<void>(::pthread_key_delete(m_tlsIndex));
        m_valid = false;
    }
}

}}}
