//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(FeatStd_Platform_Posix_PosixTcpIp_h)
#define FeatStd_Platform_Posix_PosixTcpIp_h

#include <FeatStd/Platform/Base.h>


namespace FeatStd {
    namespace Internal {
        typedef Int SOCKET;
        namespace Posix {
            /// @addtogroup FEATSTD_PLATFORM_Posix
            /// @{
            // /** Posix TcpIp functionality supporting implementation of FeatStd::Internal::TcpIp. */
            class PosixTcpIp {
            public:
                typedef FeatStd::Internal::TcpIpSettings Settings;
                PosixTcpIp();

                bool DataAvailable(bool& available);
                Int32 Read(UInt8*buffer, UInt32 length);
                Int32 Write(const UInt8* buffer, UInt32 length);
                bool Configure(Settings const * configData);
                bool Close();
                bool Connect(ConnectionHandshake handshake = 0);
                bool Connected();
                Settings const * GetConfiguration() const{ return &mSettings; }

            private:


                SOCKET mSocket;

                Settings mSettings;
                
                // Non-Blocking helper member
                bool mIsConnecting;
                SOCKET mListenerSocket;
            };
            /// @}
        }
    }
}

namespace FeatStd {
    namespace Internal {
        namespace Impl {
            typedef FeatStd::Internal::Posix::PosixTcpIp TcpIp;
        }
    }
}

#endif
