//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(FeatStd_Platform_Posix_PosixCriticalSection_h)
#define FeatStd_Platform_Posix_PosixCriticalSection_h

#include <FeatStd/Platform/Base.h>

#include <pthread.h>

namespace FeatStd { namespace Internal { namespace Posix {
    /// @addtogroup FEATSTD_PLATFORM_POSIX
    /// @{
    /** Posix specific implementation for critical sections */
    class PosixCriticalSection {
    public:
        ///
        PosixCriticalSection();

        ///
        ~PosixCriticalSection();

        ///
        void Obtain();

        ///
        void Release();

        ///
        bool Try();

    private:
        pthread_mutex_t m_mutex;
        pthread_mutexattr_t m_mutexAttributes;

        FEATSTD_MAKE_CLASS_UNCOPYABLE(PosixCriticalSection);
    };
    /// @}
}}}

namespace FeatStd { namespace Internal { namespace Impl {
    typedef FeatStd::Internal::Posix::PosixCriticalSection CriticalSection;
}}}


#endif
