//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "PosixCriticalSection.h"
#include <FeatStd/Platform/Thread.h>

namespace FeatStd { namespace Internal { namespace Posix {
    
    FEATSTD_LINT_CURRENT_SCOPE(1401, "Violates MISRA C++ 2008 Required Rule 8-5-1: false positive, not initialized is wrong") 
    FEATSTD_LINT_CURRENT_SCOPE(1960, "Violates MISRA C++ 2008 Required Rule 5-18-1: false positive, comma operator is not used")    
    // ------------------------------------------------------------------------
    PosixCriticalSection::PosixCriticalSection()
    {
        static_cast<void>(::pthread_mutexattr_init(&m_mutexAttributes));
        static_cast<void>(::pthread_mutexattr_settype(&m_mutexAttributes, PTHREAD_MUTEX_RECURSIVE));
        static_cast<void>(::pthread_mutex_init(&m_mutex, &m_mutexAttributes));
    }

    // ------------------------------------------------------------------------
    PosixCriticalSection::~PosixCriticalSection()
    {
    }

    // ------------------------------------------------------------------------
    void PosixCriticalSection::Obtain()
    {
        FEATSTD_LINT_SYMBOL(1762, FeatStd::Internal::Posix::PosixCriticalSection::Obtain, "Violates MISRA C++ 2008 Required Rule 9-3-3: function has side effects and is therefore considered non-const")
        static_cast<void>(::pthread_mutex_lock(&m_mutex));
    }

    // ------------------------------------------------------------------------
    void PosixCriticalSection::Release()
    {
        FEATSTD_LINT_SYMBOL(1762, FeatStd::Internal::Posix::PosixCriticalSection::Release, "Violates MISRA C++ 2008 Required Rule 9-3-3: function has side effects and is therefore considered non-const")
        static_cast<void>(::pthread_mutex_unlock(&m_mutex));
    }

    // ------------------------------------------------------------------------
    bool PosixCriticalSection::Try()
    {
        FEATSTD_LINT_SYMBOL(1762, FeatStd::Internal::Posix::PosixCriticalSection::Try, "Violates MISRA C++ 2008 Required Rule 9-3-3: function has side effects and is therefore considered non-const")
        FEATSTD_LINT_NEXT_EXPRESSION(948, "Violates MISRA C++ 2008 Required Rule 0-1-9: false positive, zero is returned if a lock is acquired")
        return (::pthread_mutex_trylock(&m_mutex) == 0);
    }
}}}

