//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "GenericMath.h"

namespace FeatStd { namespace Internal { namespace Generic {

// see http://www.cygnus-software.com/papers/comparingfloats/comparingfloats.htm
// this algorithm is sufficient for our purposes
bool GenericMath::FloatAlmostEqual(Float a, Float b, Float relativeEpsilon, Float absoluteEpsilon)
{
    Float absoluteError = Absolute(a - b);
    if (absoluteError < absoluteEpsilon){
        return true;
    }

    Float aa(Absolute(a));
    Float ab(Absolute(b));

    Float relativeError;
    if (ab > aa) {
        relativeError = absoluteError / ab;
    } else {
        relativeError = absoluteError / aa;
    }

    if (relativeError <= relativeEpsilon) {
        return true;
    }

    return false;
}
}}}
