//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(FeatStd_Platform_Generic_GenericDiagnostic_h)
#define FeatStd_Platform_Generic_GenericDiagnostic_h

#include <FeatStd/Platform/Base.h>

#include <FeatStd/Platform/VarArg.h>

FEATSTD_LINT_FILE(829, stdlib.h, "platform dependent file")
#include <stdlib.h>

// HMIBase modified: macro already defined in BoschCustomDiagnostic.h
#ifndef FEATSTD_OS_BREAK
#define FEATSTD_OS_BREAK() abort() // Or while (true); for endless loop
#endif

namespace FeatStd { namespace Internal { namespace Generic {
/// @addtogroup FEATSTD_PLATFORM_GENERIC
/// @{
/**
* @brief Abstraction layer for diagnostic methods.
*/
class GenericDiagnostic
{
public:
    /// Uses simple printf
    static void ConsoleOut(const Char* messageFormat, va_list argList);

    /// Uses simple printf
    static void DebuggerOut(const Char* messageFormat, va_list argList);

    /**
     * Displays message and terminates program execution.
     * @param message Info about reason.
     */
    static void Panic(const Char* message);

#ifdef FEATSTD_DEBUG
    /**
    * Aborts programm execution.
    *
    * @return if programm should run into a breakpoint (not used).
    */
    static bool Assert(const Char* expression,
                       const Char* filename, Int linenumber);
#endif
};
/// @}
}}}

namespace FeatStd { namespace Internal { namespace Impl {
    typedef FeatStd::Internal::Generic::GenericDiagnostic Diagnostic;
}}}
#endif
