//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "GenericDiagnostic.h"

#include <FeatStd/Diagnostics/ErrorHandling.h>

FEATSTD_LINT_FILE(829, stdio.h, "platform dependent file")
FEATSTD_LINT_FILE(829, stdlib.h, "platform dependent file")
FEATSTD_LINT_FILE(829, assert.h, "platform dependent file")
#include <stdio.h>
#include <stdlib.h>
#include <assert.h>

namespace FeatStd { namespace Internal { namespace Generic {
void GenericDiagnostic::ConsoleOut(const Char* messageFormat, va_list argList)
{
    static_cast<void>(vprintf(messageFormat, argList));
}

void GenericDiagnostic::DebuggerOut(const Char* messageFormat, va_list argList)
{
    static_cast<void>(vprintf(messageFormat, argList));
}

void GenericDiagnostic::Panic(const Char* message)
{
    // No checks, don't stress the system.
    printf("%s", message);

    FEATSTD_LINT_NEXT_EXPRESSION(586, "platform dependent code, thus behavior is known")
    abort();
}

#ifdef FEATSTD_DEBUG
bool GenericDiagnostic::Assert(const Char* expression,
                               const Char* filename, Int linenumber)
{
#ifdef __ghs__
    _assert(expression, filename, linenumber);
#elif defined(__CC_ARM) || defined (__ICCARM__) || defined (FEATSTD_OS_QNX)
    assert(expression);
    FEATSTD_UNUSED2(filename, linenumber);
#else
    // Use POSIX variant as default
    __assert_fail(expression, filename, linenumber, 0);
#endif
    FEATSTD_PANIC("assert shouldn't return!");

    return true; // Not of further interest
}
#endif
}}}
