//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(FeatStd_Platform_Generic_GenericAtomicOp_h)
#define FeatStd_Platform_Generic_GenericAtomicOp_h

#include <FeatStd/Base.h>

#if defined(FEATSTD_TOOLCHAIN_HAS_BUILTIN_ATOMICOP)
#   include FEATSTD_TOOLCHAIN_INCLUDE(AtomicOp)
#else

namespace FeatStd { namespace Internal { namespace Generic {

    /** Generic implementation for atomic operations with critical section
        this implementation should not be used for productive environment. 
        A single critical section to lock all atomic variables decreases
        overall performance significantly */
    class GenericAtomicOp {
        public:
            typedef int Type;

            static Type FetchAndAdd(Type &atomic, Type value);
            static Type FetchAndSub(Type &atomic, Type value);
            static Type AddAndFetch(Type &atomic, Type value);
            static Type SubAndFetch(Type &atomic, Type value);
            static Type Set(Type & value, Type new_value);
            static bool TestAndSet(Type & value, Type expected_value, Type new_value);
    };
}}}

namespace FeatStd { namespace Internal { namespace Impl {
    typedef FeatStd::Internal::Generic::GenericAtomicOp AtomicOp;
}}}

#endif

#endif
