//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(FeatStd_Platform_FractionalNumber_h)
    #define FeatStd_Platform_FractionalNumber_h

// Switch between floating point and fixed point fractional numbers.

#ifdef FEATSTD_FIXED_POINT_ARITHMETIC
    // Enable fixed point.
    #include "FixedPoint/FixedPoint.h"
    #include "FixedPoint/IntegeralBits.h"

    #define FEATSTD_FRACTIONAL_NUMBER_TYPE_NAME \
        "int" \
        FEATSTD_STRINGIZE(FEATSTD_FIXED_POINT_INTEGRAL_BITS) \
        ":" \
        FEATSTD_STRINGIZE(FEATSTD_FIXED_POINT_FRACTIONAL_BITS)
#else
    // Enable floating point.
    #define FEATSTD_FRACTIONAL_NUMBER_TYPE_NAME "float"
#endif

namespace FractionalNumber {
/// @addtogroup FEATSTD_PLATFORM
/// @{
    #ifdef FEATSTD_FIXED_POINT_ARITHMETIC
        // Enable fixed point.

        /**
         * Float data type.
         * Float is replaced by fixed point data with 32 bits.
         * FEATSTD_FIXED_POINT_FRACTIONAL_BITS represents the number of bits used
         * as a fractional part.
         * The integral part is represented on 31 - FEATSTD_FIXED_POINT_FRACTIONAL_BITS.
         * There is one sign bit.
         */
        typedef FeatStd::Internal::FixedPoint<FEATSTD_FIXED_POINT_FRACTIONAL_BITS> Float;
    #endif
 /// @}
}
#endif  // FeatStd_Platform_FractionalNumber_h
