//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(FeatStd_Platform_Diagnostic_h)
#define FeatStd_Platform_Diagnostic_h

#include <FeatStd/Platform/Base.h>

#include <FeatStd/Platform/VarArg.h>

#include FEATSTD_PLATFORM_INCLUDE(Diagnostic)

#if !defined(FEATSTD_LOG_FUNC)
//    Can be overwritten in xxxPlatform if not supported by compiler
    #define FEATSTD_LOG_FUNC __func__
#endif

#if !defined(FEATSTD_OS_BREAK) // Can be used in Release versions also!
    #error Must be defined in xxxPlatform
#endif

namespace FeatStd { namespace Internal {
/// @addtogroup FEATSTD_PLATFORM
/// @{
/**
* @brief Abstraction layer for diagnostics methods.
*/
class Diagnostic : private Impl::Diagnostic
{
    typedef Impl::Diagnostic Base;

public:
    /// Sends message to console (if available).
    static void ConsoleOut(const Char* messageFormat, ...)
    {
        FEATSTD_VALIST lArgs;
        FEATSTD_VASTART(lArgs, messageFormat);
        Base::ConsoleOut(messageFormat, lArgs);
        FEATSTD_VAEND(lArgs);
    }

    /// Sends message to debugger output window (if available).
    static void DebuggerOut(const Char* messageFormat, ...)
    {
        FEATSTD_VALIST lArgs;
        FEATSTD_VASTART(lArgs, messageFormat);
        Base::DebuggerOut(messageFormat, lArgs);
        FEATSTD_VAEND(lArgs);
    }

    /**
     * Displays message and terminates program execution.
     * @param message Info about reason.
     */
    static void Panic(const Char* message) { Base::Panic(message); }

#ifdef FEATSTD_DEBUG
    /**
     * Handles the assertion in a platform specific way.
     *
     * Either the implementation aborts programm execution by calling assert()
     * or it returns if the programm should run into a breakpoint.
     */
    static inline bool Assert(const Char *expression,
                              const Char *fileName, Int lineNr)
    {
        return Base::Assert(expression, fileName, lineNr);
    }
#endif
};
/// @}
}}
#endif
