#ifndef FeatStd_Platform_CommunicationSettings_h
#define FeatStd_Platform_CommunicationSettings_h

#include <FeatStd/Platform/Base.h>


namespace FeatStd {
    namespace Internal {

        typedef bool(*ConnectionHandshake)();
        struct TcpIpSettings{
            ConnectionHandshake pConnectionHandshake;
            Char Server[16];
            Char Port[6];
            bool isServer;
            bool waitForAvailableClient;
            TcpIpSettings() :pConnectionHandshake(0), isServer(false), waitForAvailableClient(false){}
        };


        enum BaudRate{
            BaudRate_0 = 0,
            BaudRate_300 = 1,
            BaudRate_1200 = 2,
            BaudRate_2400 = 3,
            BaudRate_4800 = 4,
            BaudRate_9600 = 5,
            BaudRate_19200 = 6,

            BaudRate_38400 = 7,
            BaudRate_57600 = 8,
            BaudRate_115200 = 9,
            BaudRate_230400 = 10,
            BaudRate_460800 = 11,
            BaudRate_921600 = 12
        };
        enum SerialParity{
            Parity_None,
            Parity_Even,
            Parity_Odd
        };
        enum SerialStopbits{
            StopBit_One,
            StopBit_OneHalfOne,
            StopBit_Two
        };

        struct SerialSettings{
            ConnectionHandshake pConnectionHandshake;
            BaudRate Baudrate;
            UInt32 WriteTimeout;
            UInt32 ReadTimeout;
            Char SerialPort[15];
            SerialParity Parity;
            SerialStopbits StopBits;
            bool enableReadPendingOnly;
            bool waitUntilHandshakeConnect;
            SerialSettings() :pConnectionHandshake(0),
                Baudrate(BaudRate_9600),
                WriteTimeout(500),
                ReadTimeout(500),
                Parity(Parity_None),
                StopBits(StopBit_One),
                enableReadPendingOnly(false),
                waitUntilHandshakeConnect(true){}
        };
    }
}
#endif
