//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#ifndef FeatStd_PerfMon_FileDumper_H
    #define FeatStd_PerfMon_FileDumper_H

#include <FeatStd/Base.h>
#include <FeatStd/Platform/File.h>

namespace FeatStd {
    namespace PerfMon {

        FEATSTD_LINT_SYMBOL(1704, FeatStd::PerfMon::FileDumper::FileDumper, "private ctor is intended, singleton")

        /** @addtogroup MonitorPerformanceReporting
          * @{
          */
        /**
         @brief Class for writing performance logs to file.
         */
        class FileDumper {
            public:


                /**
                 * Opens a performance log file for recording.
                 * @param filePath The path to the file to use for performance log
                 *                 recording.
                 */
                static void Open(Char* filePath);

                /**
                 * Flushes the performance log buffer contents to file.
                 */
                static bool Flush();

                /**
                 * Flushes the performance log buffer contents to file and closes
                 * the file.
                 */
                static bool FlushAndClose();

            private:
                FileHandle m_fp;

                FileDumper() : m_fp(0) {}

                /**
                 * Singleton pattern implementation; retrieves the sole instance.
                 */
                static FileDumper& GetInstance();

                /**
                 * Creates a performance log file.
                 * @param filePath Path and file name of the performance log.
                 */
                void OpenLog(Char* filePath);


                /**
                 * Closes the currently open performance log file.
                 */
                void CloseLog();

                /**
                 * Callback function for writing performance log data to file.
                 * @param data   Buffer with data to write.
                 * @param nBytes Number of bytes to write.
                 * @param userData User data to append.
                 */
                static bool FlushLog(const void* data, SizeType nBytes, void* userData);
        };

        /** @} */

    }
}
#endif // !defined FeatStd_PerfMon_FileDumper_H
