//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(FeatStd_Macros_h)
#define FeatStd_Macros_h

#include <FeatStd/Util/ConvenienceMacros.h>

/// @addtogroup FEATSTD
/// @{
/******************************************************************************
 *  FEATSTD_DEPRECATED_[CURRENT_VERSION]
 *  Macro to mark a function as deprecated.
 *  Notes, that this interface will be removed in future version!
 *
 *  #define FEATSTD_DEPRECATED_1_0_0(msg, func) _FEATSTD_DEPRECATED(msg, func)
 *
 *  Usage (example):
 *  FEATSTD_DEPRECATED_1_0_0("Use NewMethod() instead!",
 *      void DeprecatedMethod()
 *  );
 ******************************************************************************/

#define FEATSTD_DEPRECATED_3_5_0(msg, func) _FEATSTD_DEPRECATED(msg, func)

/******************************************************************************
 *  Macros to allow unit test class as friend of FeatStd classes
 *
 *  usage in .h file:
 *  @code
 *  FEATSTD_UNIT_TEST_CLASS_DECLARATION(TestClass);
 *  FEATSTD_UNIT_TEST_TESTCASE_DECLARATION(TestCaseName, TestName);
 *
 *  namespace FeatStd {
 *      class A
 *      {
 *          ...
 *          private:
 *              FEATSTD_UNIT_TEST_CLASS_FRIEND(TestClass);
 *              FEATSTD_UNIT_TEST_TESTCASE_FRIEND(TestCaseName, TestName);
 *              ...
 *      };
 *      ....
 *  }
 *  @endcode
 ******************************************************************************/
#define FEATSTD_UNIT_TEST_CLASS_DECLARATION(className) \
    namespace FeatStd { namespace UnitTest { \
        class className; \
    }}

#define FEATSTD_UNIT_TEST_TESTCASE_DECLARATION(testCaseName, testName) \
    namespace FeatStd { namespace UnitTest { \
        class _FEATSTD_UNIT_TEST_CLASS_NAME(testCaseName, testName); \
    }}

#define FEATSTD_UNIT_TEST_CLASS_FRIEND(className) \
    friend class FeatStd::UnitTest::className

#define FEATSTD_UNIT_TEST_TESTCASE_FRIEND(testCaseName, testName) \
    friend class FeatStd::UnitTest::_FEATSTD_UNIT_TEST_CLASS_NAME(testCaseName, testName)

/// @}
#endif
