//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(FeatStd_Diagnostics_MemoryAppender_h)
#define FeatStd_Diagnostics_MemoryAppender_h

#include <FeatStd/Base.h>
#ifndef FEATSTD_LOG_ENABLED
#error Feature FEATSTD_LOG_ENABLED is not enabled. Do not include any FeatStd logging releated header files!
#endif

#include "Appender.h"

namespace FeatStd {
    namespace Diagnostics {

        /// @addtogroup FEATSTD_DIAGNOSTICS
        /// @{

        /**
         * Appends log events to a buffer in memory.
         */
        class MemoryAppender : public Appender {
                typedef Appender Base;

            public:
                /**
                 *  @param  location    The location of the buffer.
                 *  @param  size        The size of the buffer.
                 */
                MemoryAppender(Char* location, SizeType size);

                virtual ~MemoryAppender();

            protected:
                // overrides Appender::DoAppend
                virtual void DoAppend(const LogEvent& logEvent);

            private:
                const Char* m_location;
                Char* m_currentLocation;
                SizeType m_size;
        };

        /// @}
    }
}
#endif
