//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(FeatStd_Diagnostics_LoggerTyped_h)
#define FeatStd_Diagnostics_LoggerTyped_h

#include <FeatStd/Util/StaticObject.h>
#include <FeatStd/Diagnostics/Logger.h>

#ifdef _MSC_VER
__pragma(warning(push))
__pragma(warning(disable:4996))
#endif

namespace FeatStd { namespace Diagnostics {
/// @addtogroup FEATSTD_DIAGNOSTICS
/// @{

FEATSTD_LINT_SYMBOL(1790, FeatStd::Diagnostics::Logger, "LoggerTyped inherits functionality from Logger - no override intended")

template <typename LogRealm>
class LoggerTyped : public Logger
{
    typedef Logger Base;

public:
    LoggerTyped() : Base(LogRealm::Name()) { }
    FEATSTD_LINT_CURRENT_SCOPE(1509, Virtual DTOR not needed. No members added.)
    ~LoggerTyped() { }

    static Logger& GetInstance() {
        FEATSTD_UNSYNCED_STATIC_OBJECT(LoggerTyped<LogRealm>, lLogger);
        return lLogger;
    }

private:
    FEATSTD_MAKE_CLASS_UNCOPYABLE(LoggerTyped);
};
/// @}
}}
#ifdef _MSC_VER
__pragma(warning(pop))
#endif
#endif
