//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(FeatStd_Diagnostics_LogEvent_h)
#define FeatStd_Diagnostics_LogEvent_h

#include <FeatStd/Base.h>
#ifndef FEATSTD_LOG_ENABLED
    #error Feature FEATSTD_LOG_ENABLED is not enabled. Do not include any FeatStd logging releated header files!
#endif

#include "LogLevel.h"

namespace FeatStd { namespace Diagnostics {
/// @addtogroup FEATSTD_DIAGNOSTICS
/// @{
struct LocationInfo;

FEATSTD_LINT_SYMBOL(1725, FeatStd::Diagnostics::LogEvent::mLocation, "class is uncopyable, thus copy operator and ctor are undefined and private")


/**
 * The internal representation of logging events.
 * LogEvent instances are passed around to the different Logger components (Appender).
 * @attention Class holds pointer to logRealmName and message!
 *            This means that CTOR parameters  must exist as long as instance exists!
 */
struct LogEvent
{
public:
    LogEvent(const Char* logRealmName, LogLevel::Enum logLevel,
             UInt32 timeStamp, const LocationInfo& location,
             UInt32 threadId, const Char* message);
    ~LogEvent();

    const Char*const mLogRealmName;
    const LogLevel::Enum mLogLevel;

    const UInt32 mTimeStamp;
    const LocationInfo& mLocation;

    const UInt32 mThreadId;

    const Char*const mMessage;

private:
    FEATSTD_MAKE_CLASS_UNCOPYABLE(LogEvent);
};
/// @}
}}
#endif
