//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#define FEATSTD_IN_DIAGNOSTICS_LOG
#include "LogControl.h"
#include "LogRealm.h"

#include "ConsoleAppender.h"

namespace FeatStd { namespace Diagnostics {
/// Affects all Logger instances!
/// Uses Default values set at system startup!
void LogControl::ResetToDefault()
{
#ifdef FEATSTD_THREADSAFETY_ENABLED
    FeatStd::Internal::CriticalSectionLocker lock(&Logger::GetCriticalSection());
#endif
    SetLogLevel(LogLevel::Warning);

    FEATSTD_DEBUG_ASSERT(GetDefaultAppender() != 0);
    FEATSTD_DEBUG_ASSERT(GetDefaultAppender() == &ConsoleAppender::GetInstance());
    SetAppender(&ConsoleAppender::GetInstance());
}

LogControl::LoggerList& LogControl::GetLoggerList()
{
    return Internal::GetLoggerList();
}

void LogControl::SetLogLevel(LogLevel::Enum level)
{
    FEATSTD_DEBUG_ASSERT(level >= LogLevel::All);
    FEATSTD_DEBUG_ASSERT(level <= LogLevel::Off);

#ifdef FEATSTD_THREADSAFETY_ENABLED
    FeatStd::Internal::CriticalSectionLocker lock(&Logger::GetCriticalSection());
#endif

    LogControl::LoggerList& lLL(GetLoggerList());
    for (LoggerList::Iterator it = lLL.Begin(); it != lLL.End(); ++it) {
        it->SetLevel(level);
    }

    Logger::SetDefaultLogLevel(level);
}

/// Affects all Logger instances!
void LogControl::SetAppender(Appender* appender)
{
    Logger::SetAppender(appender);
}

/// Affects all Logger instances!
void LogControl::AppendAppender(Appender* appender)
{
    FEATSTD_DEBUG_ASSERT(appender != 0);

    Logger::AppendAppender(appender);
}

/// Affects all Logger instances!
void LogControl::RemoveAppender(Appender* appender)
{
    FEATSTD_DEBUG_ASSERT(appender != 0);

    Logger::RemoveAppender(appender);
}
}}
