//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(FeatStd_Diagnostics_FileAppender_h)
#define FeatStd_Diagnostics_FileAppender_h

#include <FeatStd/Base.h>
#ifndef FEATSTD_LOG_ENABLED
    #error Feature FEATSTD_LOG_ENABLED is not enabled. Do not include any FeatStd logging releated header files!
#endif

#include "Appender.h"

#include <FeatStd/Diagnostics/Log.h>

#include <FeatStd/Platform/File.h>

FEATSTD_UNIT_TEST_CLASS_DECLARATION(FileAppenderTest)

namespace FeatStd { namespace Diagnostics {
/// @addtogroup FEATSTD_DIAGNOSTICS
/// @{
/**
 *  Appends log events to a file.
 *  @remark File has to be opened before first call of DoAppend.
 *  @remark File will be closed in DTOR if not closed explicitly by Close.
 */
//! [FEATSTD_LOG_SET_REALM_H]
class FileAppender : public Appender
{
    typedef Appender Base;

    FEATSTD_LOG_SET_REALM(Diagnostics::LogRealm::FeatStdSystem);
//! [FEATSTD_LOG_SET_REALM_H]

public:
    /**
     *  Constructor
     */
    FileAppender();

    /**
     *  Destructor
     */
    virtual ~FileAppender();

    /**
     *  Retrieves whether the file is open or not.
     *  @return True if file is open, false otherwise.
     */
    bool IsFileOpened() const;

    /**
     *  Opens file to be used.
     *  @param filename The name of the file
     *  @param append true  Append to content, false Overwrite content. default = false
     *  @return True if successful, false otherwise.
     */
    bool Open(const Char* filename, bool append = false);

    /**
     *  Closes the current file.
     *  @return True if successful, false otherwise.
     */
    FEATSTD_LINT_CLEANUP_FUNCTION(FeatStd::Diagnostics::FileAppender::Close)
    bool Close();

    /**
     *  Writes buffer to file.
     */
    void Flush();

protected:
    /**
     *  Writes one line per log logEvent (ASCII) to mFilePointer.
     *  @param logEvent The LogEvent that is set.
     */
    virtual void DoAppend(const LogEvent& logEvent);

    void CheckedFileWrite(const Char* buffer);

private:
    FileHandle mFilePointer;

    FEATSTD_UNIT_TEST_CLASS_FRIEND(FileAppenderTest);
};
/// @}
}}
#endif
