//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(FeatStd_Diagnostics_DebugControl_h)
#define FeatStd_Diagnostics_DebugControl_h

#include <FeatStd/Base.h>

#if defined(FEATSTD_DEBUG)
namespace FeatStd { namespace Diagnostics {
/// @addtogroup FEATSTD_DIAGNOSTICS
/// @{
class IDebugControlHook;

/**
 * Main class for debugging (Design by contract) functionality.
 * This means that corresponding functionality (see Debug.h) is
 * available in debug mode (FEATSTD_DEBUG) only.
 */
class DebugControl
{
public:
    /**
     * Signals an assertion and retrieves if program should be halted.
     * @param expression Expression evaluated in FEATSTD_DEBUG_ASSERT.
     * @param filename   Location of calling FEATSTD_DEBUG_ASSERT.
     * @param lineNr     Location of calling FEATSTD_DEBUG_ASSERT.
     * @returns true if break (FEATSTD_DEBUG_BREAK) should be performed.
     */
    static bool Assert(const Char* expression,
                       const Char* filename, Int lineNr);

    /**
     * Sets hook to overwrite default behavior.
     * @param hookObject New hook object.
     * @returns previous hook object.
     */
    static IDebugControlHook* SetHook(IDebugControlHook* hookObject);

private:
    static IDebugControlHook* mHookObject;

    FEATSTD_MAKE_CLASS_STATIC(DebugControl);
};

/**
 * Interface for hook object implementation.
 */
class IDebugControlHook
{
public:
    /**
     * Method to be called instead of default behaviour in DebugControl::Assert.
     * @param expression Expression evaluated in FEATSTD_DEBUG_ASSERT.
     */
    virtual void HookMethod(const Char* expression) = 0;

    /**
    * Destructs an IDebugControlHook object.
    */
    virtual ~IDebugControlHook() {}
};

/// Helper class used by FEATSTD_DEBUG_REENTRANCE_GUARD
class ReentranceGuard
{
public:
    ReentranceGuard(UInt32& entryCount);
    ~ReentranceGuard() { mEntryCount--; }

private:
    UInt32& mEntryCount;

    FEATSTD_MAKE_CLASS_UNCOPYABLE(ReentranceGuard);
};
/// @}
}}
#else
#endif
#endif
