//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(FeatStd_Diagnostics_Appender_h)
#define FeatStd_Diagnostics_Appender_h

#include <FeatStd/Base.h>
#ifndef FEATSTD_LOG_ENABLED
    #error Feature FEATSTD_LOG_ENABLED is not enabled. Do not include any FeatStd logging releated header files!
#endif

#include <FeatStd/Container/LinkedList.h>

namespace FeatStd { namespace Diagnostics {
/// @addtogroup FEATSTD_DIAGNOSTICS
/// @{
struct LogEvent;

/**
 * Base class for specialized (outputting strategy) Appender implementations.
 * Appender instances are connected to Logger instances to handle presentation
 * of log messages.
 * @remarks A derived class must implement DoAppend.
 */
class Appender
{
public:
    /**
     *  Constructor
     */
    Appender();

    /**
     *  Destructor
     */
    virtual ~Appender();

    /**
     *  Verifies LogEvent and calls DoAppend afterwards.
     *  @param logEvent The LogEvent that is set.
     */
    void Append(const LogEvent& logEvent);

    typedef FeatStd::Internal::LinkedListNode<Appender> AppenderListNode;
    /// LinkedList requires it public :-))
    AppenderListNode mAppenderListNode;

protected:
    /// Implements outputting strategy.
    virtual void DoAppend(const LogEvent& logEvent) = 0;
};
/// @}
}}
#endif
