//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "Appender.h"
#include <FeatStd/Diagnostics/Debug.h>
#include <FeatStd/Diagnostics/Log.h>

#include <FeatStd/Diagnostics/LogEvent.h>
#include <FeatStd/Diagnostics/Logger.h>

namespace FeatStd { namespace Diagnostics {

Appender::Appender()
{
    // Ensures that the static critical section used within the logger to be created before any appender instance.
    // This is needed so that in a DestructStaticObjects call, this to be destructed after all static appender instances have been destructed.
    // This is needed as the critical section instance is used within RemoveAppender call from the Appender dtor.
#ifdef FEATSTD_THREADSAFETY_ENABLED
    static_cast<void>(Logger::GetCriticalSection());
#endif
}

Appender::~Appender()
{
    FeatStd::Diagnostics::LogControl::RemoveAppender(this);
}

/// Check concurrent/recursive calls.
//! [FEATSTD_DEBUG_REENTRANCE_GUARD]
void Appender::Append(const LogEvent& logEvent)
{
    FEATSTD_DEBUG_REENTRANCE_GUARD();
//! [FEATSTD_DEBUG_REENTRANCE_GUARD]

    FEATSTD_DEBUG_ASSERT(logEvent.mLogLevel != LogLevel::Off);
    FEATSTD_DEBUG_ASSERT(logEvent.mMessage != 0);

    DoAppend(logEvent);
}
}}
