//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(FEATSTD_ASYNCREQUEST_H)
#define FEATSTD_ASYNCREQUEST_H

#include <FeatStd/Async/AsyncRequestBase.h>

#ifdef FEATSTD_THREADSAFETY_ENABLED
#include <FeatStd/Platform/CriticalSectionLocker.h>
#endif
#include <FeatStd/Platform/Semaphore.h>
#include <FeatStd/MemoryManagement/SharedPointer.h>
#include <FeatStd/Container/Vector.h>
#include <FeatStd/Platform/Thread.h>

namespace FeatStd {
/// @addtogroup FEATSTD_ASYNC
/// @{

/**
* @brief The AsyncRequest<T> template provides the base class for all requests with a specific result type.
*/
template <typename _ResultType>
class AsyncRequest : public AsyncRequestBase
{
public:
    typedef _ResultType ResultType;

    FEATSTD_TYPEDEF_SHARED_POINTER(AsyncRequest<ResultType>);

    AsyncRequest() :
        m_result(ResultType())
    {
    }

    virtual ~AsyncRequest() {}

    /**
    * Returns the result of the asynchronous request.
    * NOTE: the result is only valid if the request is in Completed state.
    */
    ResultType GetResult() const
    {
#ifdef FEATSTD_THREADSAFETY_ENABLED
        FeatStd::Internal::CriticalSectionLocker lock(&GetCriticalSection());
#endif
        FEATSTD_DEBUG_ASSERT(Completed == GetState());
        return m_result;
    }

protected:
    /**
    * Sets the result. The state will be set to Completed by the dispatcher.
    */
    void SetResult(ResultType result)
    {
#ifdef FEATSTD_THREADSAFETY_ENABLED
        FeatStd::Internal::CriticalSectionLocker lock(&GetCriticalSection());
#endif
        m_result = result;
    }

    ResultType m_result;
};

template <>
class AsyncRequest<void> : public AsyncRequestBase
{
public:
    FEATSTD_TYPEDEF_SHARED_POINTER(AsyncRequest<void>);

    AsyncRequest() {}

    virtual ~AsyncRequest() {}
};
/// @}

namespace Internal {

using FeatStd::AsyncRequest;

template <typename ArgumentType0, typename ArgumentType1, typename ArgumentType2, typename ArgumentType3, typename ArgumentType4, typename ArgumentType5, typename ArgumentType6, typename ArgumentType7, typename ArgumentType8, typename ArgumentType9>
class VoidCallbackAsyncRequest10 : public AsyncRequest<void>
{
public:
    typedef void(*CallbackType)(ArgumentType0 argument0, ArgumentType1 argument1, ArgumentType2 argument2, ArgumentType3 argument3, ArgumentType4 argument4, ArgumentType5 argument5, ArgumentType6 argument6, ArgumentType7 argument7, ArgumentType8 argument8, ArgumentType9 argument9);
    VoidCallbackAsyncRequest10(CallbackType callback, ArgumentType0 argument0, ArgumentType1 argument1, ArgumentType2 argument2, ArgumentType3 argument3, ArgumentType4 argument4, ArgumentType5 argument5, ArgumentType6 argument6, ArgumentType7 argument7, ArgumentType8 argument8, ArgumentType9 argument9) :
        m_callback(callback),
        m_argument0(argument0),
        m_argument1(argument1),
        m_argument2(argument2),
        m_argument3(argument3),
        m_argument4(argument4),
        m_argument5(argument5),
        m_argument6(argument6),
        m_argument7(argument7),
        m_argument8(argument8),
        m_argument9(argument9)
    {
    }

    virtual void Execute()
    {
        if (0 != m_callback) {
            m_callback(m_argument0, m_argument1, m_argument2, m_argument3, m_argument4, m_argument5, m_argument6, m_argument7, m_argument8, m_argument9);
        }
    }

protected:
    CallbackType m_callback;
    ArgumentType0 m_argument0;
    ArgumentType1 m_argument1;
    ArgumentType2 m_argument2;
    ArgumentType3 m_argument3;
    ArgumentType4 m_argument4;
    ArgumentType5 m_argument5;
    ArgumentType6 m_argument6;
    ArgumentType7 m_argument7;
    ArgumentType8 m_argument8;
    ArgumentType9 m_argument9;
};


template <typename ArgumentType0, typename ArgumentType1, typename ArgumentType2, typename ArgumentType3, typename ArgumentType4, typename ArgumentType5, typename ArgumentType6, typename ArgumentType7, typename ArgumentType8>
class VoidCallbackAsyncRequest9 : public AsyncRequest<void>
{
public:
    typedef void(*CallbackType)(ArgumentType0 argument0, ArgumentType1 argument1, ArgumentType2 argument2, ArgumentType3 argument3, ArgumentType4 argument4, ArgumentType5 argument5, ArgumentType6 argument6, ArgumentType7 argument7, ArgumentType8 argument8);
    VoidCallbackAsyncRequest9(CallbackType callback, ArgumentType0 argument0, ArgumentType1 argument1, ArgumentType2 argument2, ArgumentType3 argument3, ArgumentType4 argument4, ArgumentType5 argument5, ArgumentType6 argument6, ArgumentType7 argument7, ArgumentType8 argument8) :
        m_callback(callback),
        m_argument0(argument0),
        m_argument1(argument1),
        m_argument2(argument2),
        m_argument3(argument3),
        m_argument4(argument4),
        m_argument5(argument5),
        m_argument6(argument6),
        m_argument7(argument7),
        m_argument8(argument8)
    {
    }

    virtual void Execute()
    {
        if (0 != m_callback) {
            m_callback(m_argument0, m_argument1, m_argument2, m_argument3, m_argument4, m_argument5, m_argument6, m_argument7, m_argument8);
        }
    }

protected:
    CallbackType m_callback;
    ArgumentType0 m_argument0;
    ArgumentType1 m_argument1;
    ArgumentType2 m_argument2;
    ArgumentType3 m_argument3;
    ArgumentType4 m_argument4;
    ArgumentType5 m_argument5;
    ArgumentType6 m_argument6;
    ArgumentType7 m_argument7;
    ArgumentType8 m_argument8;
};

template <typename ArgumentType0, typename ArgumentType1, typename ArgumentType2, typename ArgumentType3, typename ArgumentType4, typename ArgumentType5, typename ArgumentType6, typename ArgumentType7>
class VoidCallbackAsyncRequest8 : public AsyncRequest<void>
{
public:
    typedef void(*CallbackType)(ArgumentType0 argument0, ArgumentType1 argument1, ArgumentType2 argument2, ArgumentType3 argument3, ArgumentType4 argument4, ArgumentType5 argument5, ArgumentType6 argument6, ArgumentType7 argument7);
    VoidCallbackAsyncRequest8(CallbackType callback, ArgumentType0 argument0, ArgumentType1 argument1, ArgumentType2 argument2, ArgumentType3 argument3, ArgumentType4 argument4, ArgumentType5 argument5, ArgumentType6 argument6, ArgumentType7 argument7) :
        m_callback(callback),
        m_argument0(argument0),
        m_argument1(argument1),
        m_argument2(argument2),
        m_argument3(argument3),
        m_argument4(argument4),
        m_argument5(argument5),
        m_argument6(argument6),
        m_argument7(argument7)
    {
    }

    virtual void Execute()
    {
        if (0 != m_callback) {
            m_callback(m_argument0, m_argument1, m_argument2, m_argument3, m_argument4, m_argument5, m_argument6, m_argument7);
        }
    }

protected:
    CallbackType m_callback;
    ArgumentType0 m_argument0;
    ArgumentType1 m_argument1;
    ArgumentType2 m_argument2;
    ArgumentType3 m_argument3;
    ArgumentType4 m_argument4;
    ArgumentType5 m_argument5;
    ArgumentType6 m_argument6;
    ArgumentType7 m_argument7;
};

template <typename ArgumentType0, typename ArgumentType1, typename ArgumentType2, typename ArgumentType3, typename ArgumentType4, typename ArgumentType5, typename ArgumentType6>
class VoidCallbackAsyncRequest7 : public AsyncRequest<void>
{
public:
    typedef void(*CallbackType)(ArgumentType0 argument0, ArgumentType1 argument1, ArgumentType2 argument2, ArgumentType3 argument3, ArgumentType4 argument4, ArgumentType5 argument5, ArgumentType6 argument6);
    VoidCallbackAsyncRequest7(CallbackType callback, ArgumentType0 argument0, ArgumentType1 argument1, ArgumentType2 argument2, ArgumentType3 argument3, ArgumentType4 argument4, ArgumentType5 argument5, ArgumentType6 argument6) :
        m_callback(callback),
        m_argument0(argument0),
        m_argument1(argument1),
        m_argument2(argument2),
        m_argument3(argument3),
        m_argument4(argument4),
        m_argument5(argument5),
        m_argument6(argument6)
    {
    }

    virtual void Execute()
    {
        if (0 != m_callback) {
            m_callback(m_argument0, m_argument1, m_argument2, m_argument3, m_argument4, m_argument5, m_argument6);
        }
    }

protected:
    CallbackType m_callback;
    ArgumentType0 m_argument0;
    ArgumentType1 m_argument1;
    ArgumentType2 m_argument2;
    ArgumentType3 m_argument3;
    ArgumentType4 m_argument4;
    ArgumentType5 m_argument5;
    ArgumentType6 m_argument6;
};

template <typename ArgumentType0, typename ArgumentType1, typename ArgumentType2, typename ArgumentType3, typename ArgumentType4, typename ArgumentType5>
class VoidCallbackAsyncRequest6 : public AsyncRequest<void>
{
public:
    typedef void(*CallbackType)(ArgumentType0 argument0, ArgumentType1 argument1, ArgumentType2 argument2, ArgumentType3 argument3, ArgumentType4 argument4, ArgumentType5 argument5);
    VoidCallbackAsyncRequest6(CallbackType callback, ArgumentType0 argument0, ArgumentType1 argument1, ArgumentType2 argument2, ArgumentType3 argument3, ArgumentType4 argument4, ArgumentType5 argument5) :
        m_callback(callback),
        m_argument0(argument0),
        m_argument1(argument1),
        m_argument2(argument2),
        m_argument3(argument3),
        m_argument4(argument4),
        m_argument5(argument5)
    {
    }

    virtual void Execute()
    {
        if (0 != m_callback) {
            m_callback(m_argument0, m_argument1, m_argument2, m_argument3, m_argument4, m_argument5);
        }
    }

protected:
    CallbackType m_callback;
    ArgumentType0 m_argument0;
    ArgumentType1 m_argument1;
    ArgumentType2 m_argument2;
    ArgumentType3 m_argument3;
    ArgumentType4 m_argument4;
    ArgumentType5 m_argument5;
};

template <typename ArgumentType0, typename ArgumentType1, typename ArgumentType2, typename ArgumentType3, typename ArgumentType4>
class VoidCallbackAsyncRequest5 : public AsyncRequest<void>
{
public:
    typedef void(*CallbackType)(ArgumentType0 argument0, ArgumentType1 argument1, ArgumentType2 argument2, ArgumentType3 argument3, ArgumentType4 argument4);
    VoidCallbackAsyncRequest5(CallbackType callback, ArgumentType0 argument0, ArgumentType1 argument1, ArgumentType2 argument2, ArgumentType3 argument3, ArgumentType4 argument4) :
        m_callback(callback),
        m_argument0(argument0),
        m_argument1(argument1),
        m_argument2(argument2),
        m_argument3(argument3),
        m_argument4(argument4)
    {
    }

    virtual void Execute()
    {
        if (0 != m_callback) {
            m_callback(m_argument0, m_argument1, m_argument2, m_argument3, m_argument4);
        }
    }

protected:
    CallbackType m_callback;
    ArgumentType0 m_argument0;
    ArgumentType1 m_argument1;
    ArgumentType2 m_argument2;
    ArgumentType3 m_argument3;
    ArgumentType4 m_argument4;
};

template <typename ArgumentType0, typename ArgumentType1, typename ArgumentType2, typename ArgumentType3>
class VoidCallbackAsyncRequest4 : public AsyncRequest<void>
{
public:
    typedef void(*CallbackType)(ArgumentType0 argument0, ArgumentType1 argument1, ArgumentType2 argument2, ArgumentType3 argument3);
    VoidCallbackAsyncRequest4(CallbackType callback, ArgumentType0 argument0, ArgumentType1 argument1, ArgumentType2 argument2, ArgumentType3 argument3) :
        m_callback(callback),
        m_argument0(argument0),
        m_argument1(argument1),
        m_argument2(argument2),
        m_argument3(argument3)
    {
    }

    virtual void Execute()
    {
        if (0 != m_callback) {
            m_callback(m_argument0, m_argument1, m_argument2, m_argument3);
        }
    }

protected:
    CallbackType m_callback;
    ArgumentType0 m_argument0;
    ArgumentType1 m_argument1;
    ArgumentType2 m_argument2;
    ArgumentType3 m_argument3;
};

template <typename ArgumentType0, typename ArgumentType1, typename ArgumentType2>
class VoidCallbackAsyncRequest3 : public AsyncRequest<void>
{
public:
    typedef void(*CallbackType)(ArgumentType0 argument0, ArgumentType1 argument1, ArgumentType2 argument2);
    VoidCallbackAsyncRequest3(CallbackType callback, ArgumentType0 argument0, ArgumentType1 argument1, ArgumentType2 argument2) :
        m_callback(callback),
        m_argument0(argument0),
        m_argument1(argument1),
        m_argument2(argument2)
    {
    }

    virtual void Execute()
    {
        if (0 != m_callback) {
            m_callback(m_argument0, m_argument1, m_argument2);
        }
    }

protected:
    CallbackType m_callback;
    ArgumentType0 m_argument0;
    ArgumentType1 m_argument1;
    ArgumentType2 m_argument2;
};

template <typename ArgumentType0, typename ArgumentType1>
class VoidCallbackAsyncRequest2 : public AsyncRequest<void>
{
public:
    typedef void(*CallbackType)(ArgumentType0 argument0, ArgumentType1 argument1);
    VoidCallbackAsyncRequest2(CallbackType callback, ArgumentType0 argument0, ArgumentType1 argument1) :
        m_callback(callback),
        m_argument0(argument0),
        m_argument1(argument1)
    {
    }

    virtual void Execute()
    {
        if (0 != m_callback) {
            m_callback(m_argument0, m_argument1);
        }
    }

protected:
    CallbackType m_callback;
    ArgumentType0 m_argument0;
    ArgumentType1 m_argument1;
};

template <typename ArgumentType0>
class VoidCallbackAsyncRequest1 : public AsyncRequest<void>
{
public:
    typedef void(*CallbackType)(ArgumentType0 argument0);
    VoidCallbackAsyncRequest1(CallbackType callback, ArgumentType0 argument0) :
        m_callback(callback),
        m_argument0(argument0)
    {
    }

    virtual void Execute()
    {
        if (0 != m_callback) {
            m_callback(m_argument0);
        }
    }

protected:
    CallbackType m_callback;
    ArgumentType0 m_argument0;
};

template <typename ArgumentType0>
class VoidCallbackAsyncRequest0 : public AsyncRequest<void>
{
public:
    typedef void(*CallbackType)();
    VoidCallbackAsyncRequest0(CallbackType callback) :
        m_callback(callback)
    {
    }

    virtual void Execute()
    {
        if (0 != m_callback) {
            m_callback();
        }
    }

protected:
    CallbackType m_callback;
};

template <typename ResultType, typename ArgumentType0, typename ArgumentType1, typename ArgumentType2, typename ArgumentType3, typename ArgumentType4, typename ArgumentType5, typename ArgumentType6, typename ArgumentType7, typename ArgumentType8, typename ArgumentType9>
class ResultCallbackAsyncRequest10 : public AsyncRequest<ResultType>
{
public:
    typedef ResultType(*CallbackType)(ArgumentType0 argument0, ArgumentType1 argument1, ArgumentType2 argument2, ArgumentType3 argument3, ArgumentType4 argument4, ArgumentType5 argument5, ArgumentType6 argument6, ArgumentType7 argument7, ArgumentType8 argument8, ArgumentType9 argument9);
    ResultCallbackAsyncRequest10(CallbackType callback, ArgumentType0 argument0, ArgumentType1 argument1, ArgumentType2 argument2, ArgumentType3 argument3, ArgumentType4 argument4, ArgumentType5 argument5, ArgumentType6 argument6, ArgumentType7 argument7, ArgumentType8 argument8, ArgumentType9 argument9) :
        m_callback(callback),
        m_argument0(argument0),
        m_argument1(argument1),
        m_argument2(argument2),
        m_argument3(argument3),
        m_argument4(argument4),
        m_argument5(argument5),
        m_argument6(argument6),
        m_argument7(argument7),
        m_argument8(argument8),
        m_argument9(argument9)
    {
    }

    virtual void Execute()
    {
        this->SetResult((0 != m_callback) ? m_callback(m_argument0, m_argument1, m_argument2, m_argument3, m_argument4, m_argument5, m_argument6, m_argument7, m_argument8, m_argument9) : ResultType());
    }

protected:
    CallbackType m_callback;
    ArgumentType0 m_argument0;
    ArgumentType1 m_argument1;
    ArgumentType2 m_argument2;
    ArgumentType3 m_argument3;
    ArgumentType4 m_argument4;
    ArgumentType5 m_argument5;
    ArgumentType6 m_argument6;
    ArgumentType7 m_argument7;
    ArgumentType8 m_argument8;
    ArgumentType9 m_argument9;
};

template <typename ResultType, typename ArgumentType0, typename ArgumentType1, typename ArgumentType2, typename ArgumentType3, typename ArgumentType4, typename ArgumentType5, typename ArgumentType6, typename ArgumentType7, typename ArgumentType8>
class ResultCallbackAsyncRequest9 : public AsyncRequest<ResultType>
{
public:
    typedef ResultType(*CallbackType)(ArgumentType0 argument0, ArgumentType1 argument1, ArgumentType2 argument2, ArgumentType3 argument3, ArgumentType4 argument4, ArgumentType5 argument5, ArgumentType6 argument6, ArgumentType7 argument7, ArgumentType8 argument8);
    ResultCallbackAsyncRequest9(CallbackType callback, ArgumentType0 argument0, ArgumentType1 argument1, ArgumentType2 argument2, ArgumentType3 argument3, ArgumentType4 argument4, ArgumentType5 argument5, ArgumentType6 argument6, ArgumentType7 argument7, ArgumentType8 argument8) :
        m_callback(callback),
        m_argument0(argument0),
        m_argument1(argument1),
        m_argument2(argument2),
        m_argument3(argument3),
        m_argument4(argument4),
        m_argument5(argument5),
        m_argument6(argument6),
        m_argument7(argument7),
        m_argument8(argument8)
    {
    }

    virtual void Execute()
    {
        this->SetResult((0 != m_callback) ? m_callback(m_argument0, m_argument1, m_argument2, m_argument3, m_argument4, m_argument5, m_argument6, m_argument7, m_argument8) : ResultType());
    }

protected:
    CallbackType m_callback;
    ArgumentType0 m_argument0;
    ArgumentType1 m_argument1;
    ArgumentType2 m_argument2;
    ArgumentType3 m_argument3;
    ArgumentType4 m_argument4;
    ArgumentType5 m_argument5;
    ArgumentType6 m_argument6;
    ArgumentType7 m_argument7;
    ArgumentType8 m_argument8;
};

template <typename ResultType, typename ArgumentType0, typename ArgumentType1, typename ArgumentType2, typename ArgumentType3, typename ArgumentType4, typename ArgumentType5, typename ArgumentType6, typename ArgumentType7>
class ResultCallbackAsyncRequest8 : public AsyncRequest<ResultType>
{
public:
    typedef ResultType(*CallbackType)(ArgumentType0 argument0, ArgumentType1 argument1, ArgumentType2 argument2, ArgumentType3 argument3, ArgumentType4 argument4, ArgumentType5 argument5, ArgumentType6 argument6, ArgumentType7 argument7);
    ResultCallbackAsyncRequest8(CallbackType callback, ArgumentType0 argument0, ArgumentType1 argument1, ArgumentType2 argument2, ArgumentType3 argument3, ArgumentType4 argument4, ArgumentType5 argument5, ArgumentType6 argument6, ArgumentType7 argument7) :
        m_callback(callback),
        m_argument0(argument0),
        m_argument1(argument1),
        m_argument2(argument2),
        m_argument3(argument3),
        m_argument4(argument4),
        m_argument5(argument5),
        m_argument6(argument6),
        m_argument7(argument7)
    {
    }

    virtual void Execute()
    {
        this->SetResult((0 != m_callback) ? m_callback(m_argument0, m_argument1, m_argument2, m_argument3, m_argument4, m_argument5, m_argument6, m_argument7) : ResultType());
    }

protected:
    CallbackType m_callback;
    ArgumentType0 m_argument0;
    ArgumentType1 m_argument1;
    ArgumentType2 m_argument2;
    ArgumentType3 m_argument3;
    ArgumentType4 m_argument4;
    ArgumentType5 m_argument5;
    ArgumentType6 m_argument6;
    ArgumentType7 m_argument7;
};

template <typename ResultType, typename ArgumentType0, typename ArgumentType1, typename ArgumentType2, typename ArgumentType3, typename ArgumentType4, typename ArgumentType5, typename ArgumentType6>
class ResultCallbackAsyncRequest7 : public AsyncRequest<ResultType>
{
public:
    typedef ResultType(*CallbackType)(ArgumentType0 argument0, ArgumentType1 argument1, ArgumentType2 argument2, ArgumentType3 argument3, ArgumentType4 argument4, ArgumentType5 argument5, ArgumentType6 argument6);
    ResultCallbackAsyncRequest7(CallbackType callback, ArgumentType0 argument0, ArgumentType1 argument1, ArgumentType2 argument2, ArgumentType3 argument3, ArgumentType4 argument4, ArgumentType5 argument5, ArgumentType6 argument6) :
        m_callback(callback),
        m_argument0(argument0),
        m_argument1(argument1),
        m_argument2(argument2),
        m_argument3(argument3),
        m_argument4(argument4),
        m_argument5(argument5),
        m_argument6(argument6)
    {
    }

    virtual void Execute()
    {
        this->SetResult((0 != m_callback) ? m_callback(m_argument0, m_argument1, m_argument2, m_argument3, m_argument4, m_argument5, m_argument6) : ResultType());
    }

protected:
    CallbackType m_callback;
    ArgumentType0 m_argument0;
    ArgumentType1 m_argument1;
    ArgumentType2 m_argument2;
    ArgumentType3 m_argument3;
    ArgumentType4 m_argument4;
    ArgumentType5 m_argument5;
    ArgumentType6 m_argument6;
};

template <typename ResultType, typename ArgumentType0, typename ArgumentType1, typename ArgumentType2, typename ArgumentType3, typename ArgumentType4, typename ArgumentType5>
class ResultCallbackAsyncRequest6 : public AsyncRequest<ResultType>
{
public:
    typedef ResultType(*CallbackType)(ArgumentType0 argument0, ArgumentType1 argument1, ArgumentType2 argument2, ArgumentType3 argument3, ArgumentType4 argument4, ArgumentType5 argument5);
    ResultCallbackAsyncRequest6(CallbackType callback, ArgumentType0 argument0, ArgumentType1 argument1, ArgumentType2 argument2, ArgumentType3 argument3, ArgumentType4 argument4, ArgumentType5 argument5) :
        m_callback(callback),
        m_argument0(argument0),
        m_argument1(argument1),
        m_argument2(argument2),
        m_argument3(argument3),
        m_argument4(argument4),
        m_argument5(argument5)
    {
    }

    virtual void Execute()
    {
        this->SetResult((0 != m_callback) ? m_callback(m_argument0, m_argument1, m_argument2, m_argument3, m_argument4, m_argument5) : ResultType());
    }

protected:
    CallbackType m_callback;
    ArgumentType0 m_argument0;
    ArgumentType1 m_argument1;
    ArgumentType2 m_argument2;
    ArgumentType3 m_argument3;
    ArgumentType4 m_argument4;
    ArgumentType5 m_argument5;
};

template <typename ResultType, typename ArgumentType0, typename ArgumentType1, typename ArgumentType2, typename ArgumentType3, typename ArgumentType4>
class ResultCallbackAsyncRequest5 : public AsyncRequest<ResultType>
{
public:
    typedef ResultType(*CallbackType)(ArgumentType0 argument0, ArgumentType1 argument1, ArgumentType2 argument2, ArgumentType3 argument3, ArgumentType4 argument4);
    ResultCallbackAsyncRequest5(CallbackType callback, ArgumentType0 argument0, ArgumentType1 argument1, ArgumentType2 argument2, ArgumentType3 argument3, ArgumentType4 argument4) :
        m_callback(callback),
        m_argument0(argument0),
        m_argument1(argument1),
        m_argument2(argument2),
        m_argument3(argument3),
        m_argument4(argument4)
    {
    }

    virtual void Execute()
    {
        this->SetResult((0 != m_callback) ? m_callback(m_argument0, m_argument1, m_argument2, m_argument3, m_argument4) : ResultType());
    }

protected:
    CallbackType m_callback;
    ArgumentType0 m_argument0;
    ArgumentType1 m_argument1;
    ArgumentType2 m_argument2;
    ArgumentType3 m_argument3;
    ArgumentType4 m_argument4;
};

template <typename ResultType, typename ArgumentType0, typename ArgumentType1, typename ArgumentType2, typename ArgumentType3>
class ResultCallbackAsyncRequest4 : public AsyncRequest<ResultType>
{
public:
    typedef ResultType(*CallbackType)(ArgumentType0 argument0, ArgumentType1 argument1, ArgumentType2 argument2, ArgumentType3 argument3);
    ResultCallbackAsyncRequest4(CallbackType callback, ArgumentType0 argument0, ArgumentType1 argument1, ArgumentType2 argument2, ArgumentType3 argument3) :
        m_callback(callback),
        m_argument0(argument0),
        m_argument1(argument1),
        m_argument2(argument2),
        m_argument3(argument3)
    {
    }

    virtual void Execute()
    {
        this->SetResult((0 != m_callback) ? m_callback(m_argument0, m_argument1, m_argument2, m_argument3) : ResultType());
    }

protected:
    CallbackType m_callback;
    ArgumentType0 m_argument0;
    ArgumentType1 m_argument1;
    ArgumentType2 m_argument2;
    ArgumentType3 m_argument3;
};

template <typename ResultType, typename ArgumentType0, typename ArgumentType1, typename ArgumentType2>
class ResultCallbackAsyncRequest3 : public AsyncRequest<ResultType>
{
public:
    typedef ResultType(*CallbackType)(ArgumentType0 argument0, ArgumentType1 argument1, ArgumentType2 argument2);
    ResultCallbackAsyncRequest3(CallbackType callback, ArgumentType0 argument0, ArgumentType1 argument1, ArgumentType2 argument2) :
        m_callback(callback),
        m_argument0(argument0),
        m_argument1(argument1),
        m_argument2(argument2)
    {
    }

    virtual void Execute()
    {
        this->SetResult((0 != m_callback) ? m_callback(m_argument0, m_argument1, m_argument2) : ResultType());
    }

protected:
    CallbackType m_callback;
    ArgumentType0 m_argument0;
    ArgumentType1 m_argument1;
    ArgumentType2 m_argument2;
};

template <typename ResultType, typename ArgumentType0, typename ArgumentType1>
class ResultCallbackAsyncRequest2 : public AsyncRequest<ResultType>
{
public:
    typedef ResultType(*CallbackType)(ArgumentType0 argument0, ArgumentType1 argument1);
    ResultCallbackAsyncRequest2(CallbackType callback, ArgumentType0 argument0, ArgumentType1 argument1) :
        m_callback(callback),
        m_argument0(argument0),
        m_argument1(argument1)
    {
    }

    virtual void Execute()
    {
        this->SetResult((0 != m_callback) ? m_callback(m_argument0, m_argument1) : ResultType());
    }

protected:
    CallbackType m_callback;
    ArgumentType0 m_argument0;
    ArgumentType1 m_argument1;
};

template <typename ResultType, typename ArgumentType0>
class ResultCallbackAsyncRequest1 : public AsyncRequest<ResultType>
{
public:
    typedef ResultType(*CallbackType)(ArgumentType0 argument0);
    ResultCallbackAsyncRequest1(CallbackType callback, ArgumentType0 argument0) :
        m_callback(callback),
        m_argument0(argument0)
    {
    }

    virtual void Execute()
    {
        this->SetResult((0 != m_callback) ? m_callback(m_argument0) : ResultType());
    }

protected:
    CallbackType m_callback;
    ArgumentType0 m_argument0;
};

template <typename ResultType>
class ResultCallbackAsyncRequest0 : public AsyncRequest<ResultType>
{
public:
    typedef ResultType(*Callback)();
    ResultCallbackAsyncRequest0(Callback callback) :
        m_callback(callback)
    {
    }

    virtual void Execute()
    {
        this->SetResult((0 != m_callback) ? m_callback() : ResultType());
    }

protected:
    Callback m_callback;
};

template <typename ClassType, typename ArgumentType0, typename ArgumentType1>
class VoidMethodAsyncRequest2 : public AsyncRequest<void>
{
public:
    typedef void (ClassType::*MethodType)(ArgumentType0 argument0, ArgumentType1 argument1);
    VoidMethodAsyncRequest2(ClassType& a_this, MethodType method, ArgumentType0 argument0, ArgumentType1 argument1) :
        m_this(a_this),
        m_method(method),
        m_argument0(argument0),
        m_argument1(argument1)
    {
    }

    virtual void Execute()
    {
        if (0 != m_method) {
            (m_this.*m_method)(m_argument0, m_argument1);
        }
    }

protected:
    ClassType& m_this;
    MethodType m_method;
    ArgumentType0 m_argument0;
    ArgumentType1 m_argument1;
};

template <typename ClassType, typename ArgumentType0>
class VoidMethodAsyncRequest1 : public AsyncRequest<void>
{
public:
    typedef void (ClassType::*MethodType)(ArgumentType0 argument0);
    VoidMethodAsyncRequest1(ClassType& a_this, MethodType method, ArgumentType0 argument0) :
        m_this(a_this),
        m_method(method),
        m_argument0(argument0)
    {
    }

    virtual void Execute()
    {
        if (0 != m_method) {
            (m_this.*m_method)(m_argument0);
        }
    }

protected:
    ClassType& m_this;
    MethodType m_method;
    ArgumentType0 m_argument0;
};

template <typename ResultType, typename ClassType, typename ArgumentType0, typename ArgumentType1>
class ResultMethodAsyncRequest2 : public AsyncRequest<ResultType>
{
public:
    typedef ResultType(ClassType::*MethodType)(ArgumentType0 argument0, ArgumentType1 argument1);
    ResultMethodAsyncRequest2(ClassType& a_this, MethodType method, ArgumentType0 argument0, ArgumentType1 argument1) :
        m_this(a_this),
        m_method(method),
        m_argument0(argument0),
        m_argument1(argument1)
    {
    }

    virtual void Execute()
    {
        this->SetResult((0 != m_method) ? (m_this.*m_method)(m_argument0, m_argument1) : ResultType());
    }

protected:
    ClassType& m_this;
    MethodType m_method;
    ArgumentType0 m_argument0;
    ArgumentType1 m_argument1;
};

template <typename ResultType, typename ClassType, typename ArgumentType0>
class ResultMethodAsyncRequest1 : public AsyncRequest<ResultType>
{
public:
    typedef ResultType(ClassType::*MethodType)(ArgumentType0 argument0);
    ResultMethodAsyncRequest1(ClassType& a_this, MethodType method, ArgumentType0 argument0) :
        m_this(a_this),
        m_method(method),
        m_argument0(argument0)
    {
    }

    virtual void Execute()
    {
        this->SetResult((0 != m_method) ? (m_this.*m_method)(m_argument0) : ResultType());
    }

protected:
    ClassType& m_this;
    MethodType m_method;
    ArgumentType0 m_argument0;
};
}}

#endif // FEATSTD_ASYNCREQUEST_H
