//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#if !defined(Courier_VisualizationTypes_h)
#define Courier_VisualizationTypes_h

#if !defined COURIER_DISABLED
#include <Courier/Base.h>
#endif
#include <FeatStd/Util/StringBuffer.h>

namespace Courier {
namespace AnimationAction {
// =========================================================================
/// @addtogroup COURIER_VISUALIZATION
/// @{
/** AnimationAction enumeration values are representing the command ids for the AnimationReqMsg message. */
enum Enum {
/** Loads a specified animation. */
    Load,
/** Starts a specified animation, loads if not already loaded. */
    Start,
/** Stops a specified animation. */
    Stop,
/** Finishes a specified animation. */
    Finish,
/** Pauses a specified animation, which can be resumed. */
    Pause,
/** Resumes a specified animation, which can be resumed. */
    Resume,
/** Unloads the specified animation. */
    Unload,
/** Stops all animations. */
    StopAll,
/** Starts an animation and stops it immediately at the start position. */
    ToBegin,
/** Starts an animation and stops it immediately at the end position. */
    ToEnd,
/** Change the animation properties. */
    Change
};
/// @}
} // namespace AnimationAction
namespace ViewAction {
// =========================================================================
/// @addtogroup COURIER_VISUALIZATION
/// @{
/** ViewAction enumeration values are representing the command ids for the ViewReqMsg message. */
enum Enum {
/** Creates a specified view object. */
    Create,
/** Creates all view objects. */
    CreateAll,
/** Destroys a specified view object. */
    Destroy,
/** Destroy all view objects. */
    DestroyAll,
/** Clears a specified view object. */
    Clear,
/** Invalidates a specified view object. */
    Invalidate,
/** Clear only the area of the camera viewport. */
    ClearCameraViewports
};
/// @}
} // namespace ViewAction
namespace TransitionAction {
// =========================================================================
/// @addtogroup COURIER_VISUALIZATION
/// @{
/** TransitionAction enumeration values are representing the command ids for the TransitionReqMsg message. */
enum Enum {
/** Starts a transition. */
    Start,
/** Resets a transition and reverts the transition. */
    Reset,
/** Finishes a transition. */
    Finish
};
/// @}
} // namespace TransitionAction
} // namespace Courier
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
namespace FeatStd {
    template<> ::FeatStd::UInt32 StringBufferAppender< ::Courier::AnimationAction::Enum >::Append(::FeatStd::StringBuffer& stringBuffer, ::Courier::AnimationAction::Enum const & object);
    template<> ::FeatStd::UInt32 StringBufferAppender< ::Courier::ViewAction::Enum >::Append(::FeatStd::StringBuffer& stringBuffer, ::Courier::ViewAction::Enum const & object);
    template<> ::FeatStd::UInt32 StringBufferAppender< ::Courier::TransitionAction::Enum >::Append(::FeatStd::StringBuffer& stringBuffer, ::Courier::TransitionAction::Enum const & object);
} // namespace FeatStd
#endif
#endif // Courier_VisualizationTypes_h
