//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#if !defined(Courier_VisualizationMsgs_h)
#define Courier_VisualizationMsgs_h

#if !defined COURIER_DISABLED
#include <Courier/Base.h>
#endif
#if defined COURIER_MESSAGE_SERIALIZATION_ENABLED
#include <Courier/Serialization/BaseSerializer.h>
#endif
#include <Courier/Messaging/Message.h>
#include <Courier/Platform/MessageFactory.h>
#include <Courier/Visualization/VisualizationTypes.h>
#include <Courier/Visualization/IViewHandler.h>
#include <Courier/Visualization/AnimationProperties.h>
#include <Courier/Visualization/ViewScene.h>
#include <Courier/Visualization/ViewPlaceholder.h>
#include <Courier/Foundation/FoundationTypes.h>
#include <CanderaBehavior/Touch/TouchInfo.h>

namespace Courier {
// ------------------------------------------------------------------------
/// @addtogroup COURIER_VISUALIZATION_MESSAGES
/// @{
                /** Executes operations on Views.
                * - (Create, "id", initContent, loadScene) Creates a view identified by 'id', initializes the scene content dependent on boolean flag initScene and loads the scene dependent on boolean flag loadScene.
                * - (CreateAll, "id", initContent, loadScene) Creates view objects automatically, 'id' defines the view and its childs which shall be created. Initialization of scenes is done dependent on boolean flag initScene. Loading of scenes is done dependent on boolean flag loadScene.
                * - (Destroy, "id", *) Destroys a view identified by 'id'.
                * - (DestroyAll, *, *) Destroys all views.
                * - (Clear, "id", *) Clears a view identified by 'id'.
                * - (Invalidate, "id", *) Invalidates a view identified by 'id'.
                <br> <br>
                Courier::ViewResMsg is the corresponding response message. */
class ViewReqMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ViewReqMsg, ::Courier::Message, 0x0C560045);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        ViewReqMsg();
        ViewReqMsg(Courier::ViewAction::Enum const & aViewAction, ::Courier::ViewId const & aViewId, bool const & aShallInitScene, bool const & aShallLoadScene);
        virtual ~ViewReqMsg();

        Courier::ViewAction::Enum const & GetViewAction() const { return mViewAction; }
        void SetViewAction(Courier::ViewAction::Enum const & value) { mViewAction = value; }
        ::Courier::ViewId const & GetViewId() const { return mViewId; }
        void SetViewId(::Courier::ViewId const & value) { mViewId = value; }
        bool const & GetShallInitScene() const { return mShallInitScene; }
        void SetShallInitScene(bool const & value) { mShallInitScene = value; }
        bool const & GetShallLoadScene() const { return mShallLoadScene; }
        void SetShallLoadScene(bool const & value) { mShallLoadScene = value; }

#if defined COURIER_MESSAGE_SERIALIZATION_ENABLED
        virtual const ::Courier::SerializationInfo * GetSerializationInfo() const;
#endif
    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mViewReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mViewReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mViewReqMsgSubscriberList[];

        Courier::ViewAction::Enum mViewAction;
        ::Courier::ViewId mViewId;
        bool mShallInitScene;
        bool mShallLoadScene;
};

/// @}

// ------------------------------------------------------------------------
/// @addtogroup COURIER_VISUALIZATION_MESSAGES
/// @{
                /** Result message which is sent after Courier::ViewReqMsg is processed.
                * - ViewAction and ViewId values corresponds to the values of ViewReqMsg.
                * - Success indicates if processing was successful or not.
                * - LoadError indicates the type of loading error.
                */
class ViewResMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ViewResMsg, ::Courier::Message, 0xD60DD439);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(4);

        static bool Subscribe(::Courier::ComponentId component, ::Courier::ComponentId before = ::Courier::ComponentType::Invalid);
        static bool Unsubscribe(::Courier::ComponentId component);

        ViewResMsg();
        ViewResMsg(Courier::ViewAction::Enum const & aViewAction, ::Courier::ViewId const & aViewId, bool const & aSuccess, Courier::ViewScene::LoadError const & aLoadError);
        virtual ~ViewResMsg();

        Courier::ViewAction::Enum const & GetViewAction() const { return mViewAction; }
        void SetViewAction(Courier::ViewAction::Enum const & value) { mViewAction = value; }
        ::Courier::ViewId const & GetViewId() const { return mViewId; }
        void SetViewId(::Courier::ViewId const & value) { mViewId = value; }
        bool const & GetSuccess() const { return mSuccess; }
        void SetSuccess(bool const & value) { mSuccess = value; }
        Courier::ViewScene::LoadError const & GetLoadError() const { return mLoadError; }
        void SetLoadError(Courier::ViewScene::LoadError const & value) { mLoadError = value; }

#if defined COURIER_MESSAGE_SERIALIZATION_ENABLED
        virtual const ::Courier::SerializationInfo * GetSerializationInfo() const;
#endif
    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mViewResMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mViewResMsgModifiableMetadata;
        static ::Courier::ComponentId mViewResMsgSubscriberList[];

        ::Courier::ComponentId mSubscribers[SubscriberListSize];

        Courier::ViewAction::Enum mViewAction;
        ::Courier::ViewId mViewId;
        bool mSuccess;
        Courier::ViewScene::LoadError mLoadError;
};

/// @}

// ------------------------------------------------------------------------
/// @addtogroup COURIER_VISUALIZATION_MESSAGES
/// @{
                /** Executes operations on Camera Groups and its referenced Views.
                * - (Create, "id", loadScene) Creates the views identified by CameraGroupId and loads the scenes dependent on boolean flag loadScene.
                * - (CreateAll, "id", loadScene) Creates all view objects automatically, CameraGroupId defines the camera group and its views which shall be loaded. Loading of scenes is done dependent on boolean flag loadScene.
                * - (Clear, "id", *) Clears all views referenced by CameraGroupId.
                * - (Invalidate, "id", *) Invalidates all views referenced by CameraGroupId.
                <br> <br>
                Courier::CameraGroupResMsg is the corresponding response message. */
class CameraGroupReqMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(CameraGroupReqMsg, ::Courier::Message, 0xD6DC7C5D);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        CameraGroupReqMsg();
        CameraGroupReqMsg(Courier::ViewAction::Enum const & aViewAction, ::Courier::ItemId const & aCameraGroupId, bool const & aShallLoadScene);
        virtual ~CameraGroupReqMsg();

        Courier::ViewAction::Enum const & GetViewAction() const { return mViewAction; }
        void SetViewAction(Courier::ViewAction::Enum const & value) { mViewAction = value; }
        ::Courier::ItemId const & GetCameraGroupId() const { return mCameraGroupId; }
        void SetCameraGroupId(::Courier::ItemId const & value) { mCameraGroupId = value; }
        bool const & GetShallLoadScene() const { return mShallLoadScene; }
        void SetShallLoadScene(bool const & value) { mShallLoadScene = value; }

#if defined COURIER_MESSAGE_SERIALIZATION_ENABLED
        virtual const ::Courier::SerializationInfo * GetSerializationInfo() const;
#endif
    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mCameraGroupReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mCameraGroupReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mCameraGroupReqMsgSubscriberList[];

        Courier::ViewAction::Enum mViewAction;
        ::Courier::ItemId mCameraGroupId;
        bool mShallLoadScene;
};

/// @}

// ------------------------------------------------------------------------
/// @addtogroup COURIER_VISUALIZATION_MESSAGES
/// @{
                /** Result message which is sent after Courier::CameraGroupReqMsg is processed.
                * - ViewAction and CameraGroupId values corresponds to the values of CameraGroupReqMsg.
                * - Success indicates if processing was successful or not.
                */
class CameraGroupResMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(CameraGroupResMsg, ::Courier::Message, 0xDD9970E4);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(4);

        static bool Subscribe(::Courier::ComponentId component, ::Courier::ComponentId before = ::Courier::ComponentType::Invalid);
        static bool Unsubscribe(::Courier::ComponentId component);

        CameraGroupResMsg();
        CameraGroupResMsg(Courier::ViewAction::Enum const & aViewAction, ::Courier::ItemId const & aCameraGroupId, bool const & aSuccess);
        virtual ~CameraGroupResMsg();

        Courier::ViewAction::Enum const & GetViewAction() const { return mViewAction; }
        void SetViewAction(Courier::ViewAction::Enum const & value) { mViewAction = value; }
        ::Courier::ItemId const & GetCameraGroupId() const { return mCameraGroupId; }
        void SetCameraGroupId(::Courier::ItemId const & value) { mCameraGroupId = value; }
        bool const & GetSuccess() const { return mSuccess; }
        void SetSuccess(bool const & value) { mSuccess = value; }

#if defined COURIER_MESSAGE_SERIALIZATION_ENABLED
        virtual const ::Courier::SerializationInfo * GetSerializationInfo() const;
#endif
    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mCameraGroupResMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mCameraGroupResMsgModifiableMetadata;
        static ::Courier::ComponentId mCameraGroupResMsgSubscriberList[];

        ::Courier::ComponentId mSubscribers[SubscriberListSize];

        Courier::ViewAction::Enum mViewAction;
        ::Courier::ItemId mCameraGroupId;
        bool mSuccess;
};

/// @}

// ------------------------------------------------------------------------
/// @addtogroup COURIER_VISUALIZATION_MESSAGES
/// @{
                /** Activates or deactivates a View identified by ViewId.
                * - Activation: controls if the view shall be activated or deactivated. If it shall be activated and the
                Scene(s) of the View is(are) not loaded it will be loaded.
                * - EnableRendering: this flag enables or disables the Candera::Camera rendering flags used by the View (Scenes).
                <br> <br>
                Courier::ActivationResMsg is the corresponding response message.
                */
class ActivationReqMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ActivationReqMsg, ::Courier::Message, 0xDAA4F737);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        ActivationReqMsg();
        ActivationReqMsg(::Courier::ViewId const & aViewId, bool const & aActivation, bool const & aEnableRendering);
        virtual ~ActivationReqMsg();

        ::Courier::ViewId const & GetViewId() const { return mViewId; }
        void SetViewId(::Courier::ViewId const & value) { mViewId = value; }
        bool const & GetActivation() const { return mActivation; }
        void SetActivation(bool const & value) { mActivation = value; }
        bool const & GetEnableRendering() const { return mEnableRendering; }
        void SetEnableRendering(bool const & value) { mEnableRendering = value; }

#if defined COURIER_MESSAGE_SERIALIZATION_ENABLED
        virtual const ::Courier::SerializationInfo * GetSerializationInfo() const;
#endif
    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mActivationReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mActivationReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mActivationReqMsgSubscriberList[];

        ::Courier::ViewId mViewId;
        bool mActivation;
        bool mEnableRendering;
};

/// @}

// ------------------------------------------------------------------------
/// @addtogroup COURIER_VISUALIZATION_MESSAGES
/// @{
                /** Result message which is sent after Courier::ActivationReqMsg is processed.
                * - ViewId corresponds to the used value of ActivationReqMsg.
                * - Success indicates if processing was successful or not.
                * - LoadError indicates the type of loading error.
                */
class ActivationResMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ActivationResMsg, ::Courier::Message, 0xD4AC7BDB);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(4);

        static bool Subscribe(::Courier::ComponentId component, ::Courier::ComponentId before = ::Courier::ComponentType::Invalid);
        static bool Unsubscribe(::Courier::ComponentId component);

        ActivationResMsg();
        ActivationResMsg(::Courier::ViewId const & aViewId, bool const & aSuccess, Courier::ViewScene::LoadError const & aLoadError);
        virtual ~ActivationResMsg();

        ::Courier::ViewId const & GetViewId() const { return mViewId; }
        void SetViewId(::Courier::ViewId const & value) { mViewId = value; }
        bool const & GetSuccess() const { return mSuccess; }
        void SetSuccess(bool const & value) { mSuccess = value; }
        Courier::ViewScene::LoadError const & GetLoadError() const { return mLoadError; }
        void SetLoadError(Courier::ViewScene::LoadError const & value) { mLoadError = value; }

#if defined COURIER_MESSAGE_SERIALIZATION_ENABLED
        virtual const ::Courier::SerializationInfo * GetSerializationInfo() const;
#endif
    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mActivationResMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mActivationResMsgModifiableMetadata;
        static ::Courier::ComponentId mActivationResMsgSubscriberList[];

        ::Courier::ComponentId mSubscribers[SubscriberListSize];

        ::Courier::ViewId mViewId;
        bool mSuccess;
        Courier::ViewScene::LoadError mLoadError;
};

/// @}

// ------------------------------------------------------------------------
/// @addtogroup COURIER_VISUALIZATION_MESSAGES
/// @{
                /** Enables or disables the rendering of a View identified by ViewId.
                * - EnableRendering: this flag enables or disables the Candera::Camera rendering flags used by the View (Scenes).
                <br> <br>
                Courier::ViewRenderingResMsg is the corresponding response message.
                */
class ViewRenderingReqMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ViewRenderingReqMsg, ::Courier::Message, 0x32BF2635);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        ViewRenderingReqMsg();
        ViewRenderingReqMsg(::Courier::ViewId const & aViewId, bool const & aEnableRendering);
        virtual ~ViewRenderingReqMsg();

        ::Courier::ViewId const & GetViewId() const { return mViewId; }
        void SetViewId(::Courier::ViewId const & value) { mViewId = value; }
        bool const & GetEnableRendering() const { return mEnableRendering; }
        void SetEnableRendering(bool const & value) { mEnableRendering = value; }

#if defined COURIER_MESSAGE_SERIALIZATION_ENABLED
        virtual const ::Courier::SerializationInfo * GetSerializationInfo() const;
#endif
    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mViewRenderingReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mViewRenderingReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mViewRenderingReqMsgSubscriberList[];

        ::Courier::ViewId mViewId;
        bool mEnableRendering;
};

/// @}

// ------------------------------------------------------------------------
/// @addtogroup COURIER_VISUALIZATION_MESSAGES
/// @{
                /** Result message which is sent after Courier::ViewRenderingReqMsg is processed.
                * - ViewId corresponds to the used value of ViewRenderingReqMsg.
                * - Success indicates if processing was successful or not.
                */
class ViewRenderingResMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ViewRenderingResMsg, ::Courier::Message, 0xE8FBDC1A);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(4);

        static bool Subscribe(::Courier::ComponentId component, ::Courier::ComponentId before = ::Courier::ComponentType::Invalid);
        static bool Unsubscribe(::Courier::ComponentId component);

        ViewRenderingResMsg();
        ViewRenderingResMsg(::Courier::ViewId const & aViewId, bool const & aSuccess);
        virtual ~ViewRenderingResMsg();

        ::Courier::ViewId const & GetViewId() const { return mViewId; }
        void SetViewId(::Courier::ViewId const & value) { mViewId = value; }
        bool const & GetSuccess() const { return mSuccess; }
        void SetSuccess(bool const & value) { mSuccess = value; }

#if defined COURIER_MESSAGE_SERIALIZATION_ENABLED
        virtual const ::Courier::SerializationInfo * GetSerializationInfo() const;
#endif
    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mViewRenderingResMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mViewRenderingResMsgModifiableMetadata;
        static ::Courier::ComponentId mViewRenderingResMsgSubscriberList[];

        ::Courier::ComponentId mSubscribers[SubscriberListSize];

        ::Courier::ViewId mViewId;
        bool mSuccess;
};

/// @}

// ------------------------------------------------------------------------
/// @addtogroup COURIER_VISUALIZATION_MESSAGES
/// @{
                /** Enables or disables the message reception of a View identified by ViewId.
                * - EnableMessaging: this flag enables or disables the reception of message by the attachted ViewController and Widgets.
                <br> <br>
                Courier::ViewMessagingResMsg is the corresponding response message.
                */
class ViewMessagingReqMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ViewMessagingReqMsg, ::Courier::Message, 0x1DE061D9);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        ViewMessagingReqMsg();
        ViewMessagingReqMsg(::Courier::ViewId const & aViewId, bool const & aEnableMessaging);
        virtual ~ViewMessagingReqMsg();

        ::Courier::ViewId const & GetViewId() const { return mViewId; }
        void SetViewId(::Courier::ViewId const & value) { mViewId = value; }
        bool const & GetEnableMessaging() const { return mEnableMessaging; }
        void SetEnableMessaging(bool const & value) { mEnableMessaging = value; }

#if defined COURIER_MESSAGE_SERIALIZATION_ENABLED
        virtual const ::Courier::SerializationInfo * GetSerializationInfo() const;
#endif
    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mViewMessagingReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mViewMessagingReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mViewMessagingReqMsgSubscriberList[];

        ::Courier::ViewId mViewId;
        bool mEnableMessaging;
};

/// @}

// ------------------------------------------------------------------------
/// @addtogroup COURIER_VISUALIZATION_MESSAGES
/// @{
                /** Result message which is sent after Courier::ViewMessagingReqMsg is processed.
                * - ViewId corresponds to the used value of ViewMessagingReqMsg.
                * - Success indicates if processing was successful or not.
                */
class ViewMessagingResMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ViewMessagingResMsg, ::Courier::Message, 0x652BC6AA);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(4);

        static bool Subscribe(::Courier::ComponentId component, ::Courier::ComponentId before = ::Courier::ComponentType::Invalid);
        static bool Unsubscribe(::Courier::ComponentId component);

        ViewMessagingResMsg();
        ViewMessagingResMsg(::Courier::ViewId const & aViewId, bool const & aSuccess);
        virtual ~ViewMessagingResMsg();

        ::Courier::ViewId const & GetViewId() const { return mViewId; }
        void SetViewId(::Courier::ViewId const & value) { mViewId = value; }
        bool const & GetSuccess() const { return mSuccess; }
        void SetSuccess(bool const & value) { mSuccess = value; }

#if defined COURIER_MESSAGE_SERIALIZATION_ENABLED
        virtual const ::Courier::SerializationInfo * GetSerializationInfo() const;
#endif
    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mViewMessagingResMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mViewMessagingResMsgModifiableMetadata;
        static ::Courier::ComponentId mViewMessagingResMsgSubscriberList[];

        ::Courier::ComponentId mSubscribers[SubscriberListSize];

        ::Courier::ViewId mViewId;
        bool mSuccess;
};

/// @}

// ------------------------------------------------------------------------
/// @addtogroup COURIER_VISUALIZATION_MESSAGES
/// @{
                /** Enables or disables Cameras and activates or deactivates the Views referenced by CameraGroupId.
                * - Activation: controls if the views shall be activated or deactivated. If they shall be activated and the scenes of the views are not loaded they will be loaded.
                * - EnableRendering: this flag enables or disables the cameras.
                * - OnlyCameraGroupCameras: this flag indicates that only cameras of the camera group shall be enabled/disabled otherwise all cameras of each view.
                <br> <br>
                Courier::CameraGroupActivationResMsg is the corresponding response message.
                */
class CameraGroupActivationReqMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(CameraGroupActivationReqMsg, ::Courier::Message, 0x78A92721);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        CameraGroupActivationReqMsg();
        CameraGroupActivationReqMsg(::Courier::ItemId const & aCameraGroupId, bool const & aActivation, bool const & aEnableRendering, bool const & aOnlyCameraGroupCameras);
        virtual ~CameraGroupActivationReqMsg();

        ::Courier::ItemId const & GetCameraGroupId() const { return mCameraGroupId; }
        void SetCameraGroupId(::Courier::ItemId const & value) { mCameraGroupId = value; }
        bool const & GetActivation() const { return mActivation; }
        void SetActivation(bool const & value) { mActivation = value; }
        bool const & GetEnableRendering() const { return mEnableRendering; }
        void SetEnableRendering(bool const & value) { mEnableRendering = value; }
        bool const & GetOnlyCameraGroupCameras() const { return mOnlyCameraGroupCameras; }
        void SetOnlyCameraGroupCameras(bool const & value) { mOnlyCameraGroupCameras = value; }

#if defined COURIER_MESSAGE_SERIALIZATION_ENABLED
        virtual const ::Courier::SerializationInfo * GetSerializationInfo() const;
#endif
    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mCameraGroupActivationReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mCameraGroupActivationReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mCameraGroupActivationReqMsgSubscriberList[];

        ::Courier::ItemId mCameraGroupId;
        bool mActivation;
        bool mEnableRendering;
        bool mOnlyCameraGroupCameras;
};

/// @}

// ------------------------------------------------------------------------
/// @addtogroup COURIER_VISUALIZATION_MESSAGES
/// @{
                /** Result message which is sent after Courier::CameraGroupActivationReqMsg is processed.
                * - CameraGroupId corresponds to the used value of CameraGroupActivationReqMsg.
                * - Success indicates if processing was successful or not.
                */
class CameraGroupActivationResMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(CameraGroupActivationResMsg, ::Courier::Message, 0xF0C7425A);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(4);

        static bool Subscribe(::Courier::ComponentId component, ::Courier::ComponentId before = ::Courier::ComponentType::Invalid);
        static bool Unsubscribe(::Courier::ComponentId component);

        CameraGroupActivationResMsg();
        CameraGroupActivationResMsg(::Courier::ItemId const & aCameraGroupId, bool const & aSuccess);
        virtual ~CameraGroupActivationResMsg();

        ::Courier::ItemId const & GetCameraGroupId() const { return mCameraGroupId; }
        void SetCameraGroupId(::Courier::ItemId const & value) { mCameraGroupId = value; }
        bool const & GetSuccess() const { return mSuccess; }
        void SetSuccess(bool const & value) { mSuccess = value; }

#if defined COURIER_MESSAGE_SERIALIZATION_ENABLED
        virtual const ::Courier::SerializationInfo * GetSerializationInfo() const;
#endif
    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mCameraGroupActivationResMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mCameraGroupActivationResMsgModifiableMetadata;
        static ::Courier::ComponentId mCameraGroupActivationResMsgSubscriberList[];

        ::Courier::ComponentId mSubscribers[SubscriberListSize];

        ::Courier::ItemId mCameraGroupId;
        bool mSuccess;
};

/// @}

// ------------------------------------------------------------------------
/// @addtogroup COURIER_VISUALIZATION_MESSAGES
/// @{
                /** Tries to loads the scene(s) (without forcing the load) of a View identified by ViewId.
                <br> <br>
                Courier::LoadResMsg is the corresponding response message.
                */
class TryLoadReqMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(TryLoadReqMsg, ::Courier::Message, 0x225B5336);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        TryLoadReqMsg();
        TryLoadReqMsg(::Courier::ViewId const & aViewId);
        virtual ~TryLoadReqMsg();

        ::Courier::ViewId const & GetViewId() const { return mViewId; }
        void SetViewId(::Courier::ViewId const & value) { mViewId = value; }

#if defined COURIER_MESSAGE_SERIALIZATION_ENABLED
        virtual const ::Courier::SerializationInfo * GetSerializationInfo() const;
#endif
    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mTryLoadReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mTryLoadReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mTryLoadReqMsgSubscriberList[];

        ::Courier::ViewId mViewId;
};

/// @}

// ------------------------------------------------------------------------
/// @addtogroup COURIER_VISUALIZATION_MESSAGES
/// @{
                /** Loads or unloads the scene(s) (loading is forced and may result in deactivation of render targets) of a View identified by ViewId.
                * - Load: this flag controls if the Candera scene(s) shall be loaded or unloaded. This will build or release the Candera::Scene context.
                <br> <br>
                Courier::LoadResMsg is the corresponding response message.
                */
class LoadReqMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(LoadReqMsg, ::Courier::Message, 0x11964546);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        LoadReqMsg();
        LoadReqMsg(::Courier::ViewId const & aViewId, bool const & aLoad);
        virtual ~LoadReqMsg();

        ::Courier::ViewId const & GetViewId() const { return mViewId; }
        void SetViewId(::Courier::ViewId const & value) { mViewId = value; }
        bool const & GetLoad() const { return mLoad; }
        void SetLoad(bool const & value) { mLoad = value; }

#if defined COURIER_MESSAGE_SERIALIZATION_ENABLED
        virtual const ::Courier::SerializationInfo * GetSerializationInfo() const;
#endif
    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mLoadReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mLoadReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mLoadReqMsgSubscriberList[];

        ::Courier::ViewId mViewId;
        bool mLoad;
};

/// @}

// ------------------------------------------------------------------------
/// @addtogroup COURIER_VISUALIZATION_MESSAGES
/// @{
            /** Stores a delayed unload request in a vector for further processing in the Render method.
            * When a delayed unload request counter reached zero, a Courier::LoadReqMsg is posted to unload the view in the next iteration loop.
            * - ViewId: the Id of the view for which corresponding render targets must be controlled.
            <br> <br>
            Courier::LoadResMsg is the corresponding response message.
            */
class DelayedUnloadMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(DelayedUnloadMsg, ::Courier::Message, 0x0DC2C710);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        DelayedUnloadMsg();
        DelayedUnloadMsg(::Courier::ViewId const & aViewId);
        virtual ~DelayedUnloadMsg();

        ::Courier::ViewId const & GetViewId() const { return mViewId; }
        void SetViewId(::Courier::ViewId const & value) { mViewId = value; }

#if defined COURIER_MESSAGE_SERIALIZATION_ENABLED
        virtual const ::Courier::SerializationInfo * GetSerializationInfo() const;
#endif
    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mDelayedUnloadMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mDelayedUnloadMsgModifiableMetadata;
        static const ::Courier::ComponentId mDelayedUnloadMsgSubscriberList[];

        ::Courier::ViewId mViewId;
};

/// @}

// ------------------------------------------------------------------------
/// @addtogroup COURIER_VISUALIZATION_MESSAGES
/// @{
                /** Result message which is sent after Courier::LoadReqMsg is processed.
                * - ViewId corresponds to the used value of LoadReqMsg.
                * - Success indicates if loading/unloading was successful or not.
                * - LoadError indicates the type of loading error.
                */
class LoadResMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(LoadResMsg, ::Courier::Message, 0x09882CBF);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(4);

        static bool Subscribe(::Courier::ComponentId component, ::Courier::ComponentId before = ::Courier::ComponentType::Invalid);
        static bool Unsubscribe(::Courier::ComponentId component);

        LoadResMsg();
        LoadResMsg(::Courier::ViewId const & aViewId, bool const & aSuccess, Courier::ViewScene::LoadError const & aLoadError);
        virtual ~LoadResMsg();

        ::Courier::ViewId const & GetViewId() const { return mViewId; }
        void SetViewId(::Courier::ViewId const & value) { mViewId = value; }
        bool const & GetSuccess() const { return mSuccess; }
        void SetSuccess(bool const & value) { mSuccess = value; }
        Courier::ViewScene::LoadError const & GetLoadError() const { return mLoadError; }
        void SetLoadError(Courier::ViewScene::LoadError const & value) { mLoadError = value; }

#if defined COURIER_MESSAGE_SERIALIZATION_ENABLED
        virtual const ::Courier::SerializationInfo * GetSerializationInfo() const;
#endif
    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mLoadResMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mLoadResMsgModifiableMetadata;
        static ::Courier::ComponentId mLoadResMsgSubscriberList[];

        ::Courier::ComponentId mSubscribers[SubscriberListSize];

        ::Courier::ViewId mViewId;
        bool mSuccess;
        Courier::ViewScene::LoadError mLoadError;
};

/// @}

// ------------------------------------------------------------------------
/// @addtogroup COURIER_VISUALIZATION_MESSAGES
/// @{
                /** Tries loading the scene(s) of a View partially identified by ViewId.
                This means loading of the asset and uploading is done step by step. This is currently done only when loading a View
                * - Load: this flag controls if the Candera scene(s) shall be loaded or unloaded. This will build or release the Candera::Scene context.
                <br> <br>
                Courier::AsyncLoadResMsg is the corresponding response message.
                Courier::AsyncLoadIndMsg is sent when loading/unloading is finished.
                */
class TryAsyncLoadReqMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(TryAsyncLoadReqMsg, ::Courier::Message, 0x95284A8D);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        TryAsyncLoadReqMsg();
        TryAsyncLoadReqMsg(::Courier::ViewId const & aViewId);
        virtual ~TryAsyncLoadReqMsg();

        ::Courier::ViewId const & GetViewId() const { return mViewId; }
        void SetViewId(::Courier::ViewId const & value) { mViewId = value; }

#if defined COURIER_MESSAGE_SERIALIZATION_ENABLED
        virtual const ::Courier::SerializationInfo * GetSerializationInfo() const;
#endif
    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mTryAsyncLoadReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mTryAsyncLoadReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mTryAsyncLoadReqMsgSubscriberList[];

        ::Courier::ViewId mViewId;
};

/// @}

// ------------------------------------------------------------------------
/// @addtogroup COURIER_VISUALIZATION_MESSAGES
/// @{
                /** Loads or unloads the scene(s) of a View partially identified by ViewId.
                This means loading of the asset and uploading is done step by step. This is currently done only when loading a View
                * - Load: this flag controls if the Candera scene(s) shall be loaded or unloaded. This will build or release the Candera::Scene context.
                <br> <br>
                Courier::AsyncLoadResMsg is the corresponding response message.
                Courier::AsyncLoadIndMsg is sent when loading/unloading is finished.
                */
class AsyncLoadReqMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(AsyncLoadReqMsg, ::Courier::Message, 0xDC3ECC80);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        AsyncLoadReqMsg();
        AsyncLoadReqMsg(::Courier::ViewId const & aViewId, bool const & aLoad);
        virtual ~AsyncLoadReqMsg();

        ::Courier::ViewId const & GetViewId() const { return mViewId; }
        void SetViewId(::Courier::ViewId const & value) { mViewId = value; }
        bool const & GetLoad() const { return mLoad; }
        void SetLoad(bool const & value) { mLoad = value; }

#if defined COURIER_MESSAGE_SERIALIZATION_ENABLED
        virtual const ::Courier::SerializationInfo * GetSerializationInfo() const;
#endif
    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mAsyncLoadReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mAsyncLoadReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mAsyncLoadReqMsgSubscriberList[];

        ::Courier::ViewId mViewId;
        bool mLoad;
};

/// @}

// ------------------------------------------------------------------------
/// @addtogroup COURIER_VISUALIZATION_MESSAGES
/// @{
                /** Result message which is sent after Courier::AsyncLoadReqMsg is processed.
                * - ViewId corresponds to the used value of AsyncLoadReqMsg.
                * - Success indicates starting of loading/unloading was successful or not.
                * - LoadError indicates the type of loading error.
                */
class AsyncLoadResMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(AsyncLoadResMsg, ::Courier::Message, 0x8A837278);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(4);

        static bool Subscribe(::Courier::ComponentId component, ::Courier::ComponentId before = ::Courier::ComponentType::Invalid);
        static bool Unsubscribe(::Courier::ComponentId component);

        AsyncLoadResMsg();
        AsyncLoadResMsg(::Courier::ViewId const & aViewId, bool const & aSuccess, Courier::ViewScene::LoadError const & aLoadError);
        virtual ~AsyncLoadResMsg();

        ::Courier::ViewId const & GetViewId() const { return mViewId; }
        void SetViewId(::Courier::ViewId const & value) { mViewId = value; }
        bool const & GetSuccess() const { return mSuccess; }
        void SetSuccess(bool const & value) { mSuccess = value; }
        Courier::ViewScene::LoadError const & GetLoadError() const { return mLoadError; }
        void SetLoadError(Courier::ViewScene::LoadError const & value) { mLoadError = value; }

#if defined COURIER_MESSAGE_SERIALIZATION_ENABLED
        virtual const ::Courier::SerializationInfo * GetSerializationInfo() const;
#endif
    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mAsyncLoadResMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mAsyncLoadResMsgModifiableMetadata;
        static ::Courier::ComponentId mAsyncLoadResMsgSubscriberList[];

        ::Courier::ComponentId mSubscribers[SubscriberListSize];

        ::Courier::ViewId mViewId;
        bool mSuccess;
        Courier::ViewScene::LoadError mLoadError;
};

/// @}

// ------------------------------------------------------------------------
/// @addtogroup COURIER_VISUALIZATION_MESSAGES
/// @{
                /** Indication message which is sent after loading of the Scene.
                * - ViewId corresponds to the used value of AsyncLoadReqMsg.
                * - Load if the request was a load or unload request.
                * - Success indicates if loading/unloading was successful or not.
                * - LoadError indicates the type of loading error.
                */
class AsyncLoadIndMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(AsyncLoadIndMsg, ::Courier::Message, 0xAC7324F7);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(4);

        static bool Subscribe(::Courier::ComponentId component, ::Courier::ComponentId before = ::Courier::ComponentType::Invalid);
        static bool Unsubscribe(::Courier::ComponentId component);

        AsyncLoadIndMsg();
        AsyncLoadIndMsg(::Courier::ViewId const & aViewId, bool const & aLoad, bool const & aSuccess, Courier::ViewScene::LoadError const & aLoadError);
        virtual ~AsyncLoadIndMsg();

        ::Courier::ViewId const & GetViewId() const { return mViewId; }
        void SetViewId(::Courier::ViewId const & value) { mViewId = value; }
        bool const & GetLoad() const { return mLoad; }
        void SetLoad(bool const & value) { mLoad = value; }
        bool const & GetSuccess() const { return mSuccess; }
        void SetSuccess(bool const & value) { mSuccess = value; }
        Courier::ViewScene::LoadError const & GetLoadError() const { return mLoadError; }
        void SetLoadError(Courier::ViewScene::LoadError const & value) { mLoadError = value; }

#if defined COURIER_MESSAGE_SERIALIZATION_ENABLED
        virtual const ::Courier::SerializationInfo * GetSerializationInfo() const;
#endif
    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mAsyncLoadIndMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mAsyncLoadIndMsgModifiableMetadata;
        static ::Courier::ComponentId mAsyncLoadIndMsgSubscriberList[];

        ::Courier::ComponentId mSubscribers[SubscriberListSize];

        ::Courier::ViewId mViewId;
        bool mLoad;
        bool mSuccess;
        Courier::ViewScene::LoadError mLoadError;
};

/// @}

// ------------------------------------------------------------------------
/// @addtogroup COURIER_VISUALIZATION_MESSAGES
/// @{
                /** Loads or unloads the Views/Scene referenced by CameraGroupId.
                * - Load: this flag controls if the Candera scene(s) shall be loaded or unloaded. This will build or release the scene context.
                <br> <br>
                Courier::CameraGroupLoadResMsg is the corresponding response message.
                */
class CameraGroupLoadReqMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(CameraGroupLoadReqMsg, ::Courier::Message, 0xE3503241);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        CameraGroupLoadReqMsg();
        CameraGroupLoadReqMsg(::Courier::ItemId const & aCameraGroupId, bool const & aLoad);
        virtual ~CameraGroupLoadReqMsg();

        ::Courier::ItemId const & GetCameraGroupId() const { return mCameraGroupId; }
        void SetCameraGroupId(::Courier::ItemId const & value) { mCameraGroupId = value; }
        bool const & GetLoad() const { return mLoad; }
        void SetLoad(bool const & value) { mLoad = value; }

#if defined COURIER_MESSAGE_SERIALIZATION_ENABLED
        virtual const ::Courier::SerializationInfo * GetSerializationInfo() const;
#endif
    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mCameraGroupLoadReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mCameraGroupLoadReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mCameraGroupLoadReqMsgSubscriberList[];

        ::Courier::ItemId mCameraGroupId;
        bool mLoad;
};

/// @}

// ------------------------------------------------------------------------
/// @addtogroup COURIER_VISUALIZATION_MESSAGES
/// @{
                /** Result message which is sent after Courier::LoadCameraGroupReqMsg is processed.
                * - CameraGroupId corresponds to the used value of LoadCameraGroupReqMsg.
                * - Success indicates if loading/unloading was successful or not.
                */
class CameraGroupLoadResMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(CameraGroupLoadResMsg, ::Courier::Message, 0x72C4626A);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(4);

        static bool Subscribe(::Courier::ComponentId component, ::Courier::ComponentId before = ::Courier::ComponentType::Invalid);
        static bool Unsubscribe(::Courier::ComponentId component);

        CameraGroupLoadResMsg();
        CameraGroupLoadResMsg(::Courier::ItemId const & aCameraGroupId, bool const & aSuccess);
        virtual ~CameraGroupLoadResMsg();

        ::Courier::ItemId const & GetCameraGroupId() const { return mCameraGroupId; }
        void SetCameraGroupId(::Courier::ItemId const & value) { mCameraGroupId = value; }
        bool const & GetSuccess() const { return mSuccess; }
        void SetSuccess(bool const & value) { mSuccess = value; }

#if defined COURIER_MESSAGE_SERIALIZATION_ENABLED
        virtual const ::Courier::SerializationInfo * GetSerializationInfo() const;
#endif
    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mCameraGroupLoadResMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mCameraGroupLoadResMsgModifiableMetadata;
        static ::Courier::ComponentId mCameraGroupLoadResMsgSubscriberList[];

        ::Courier::ComponentId mSubscribers[SubscriberListSize];

        ::Courier::ItemId mCameraGroupId;
        bool mSuccess;
};

/// @}

// ------------------------------------------------------------------------
/// @addtogroup COURIER_VISUALIZATION_MESSAGES
/// @{
                /** Sets the themename to be used when loading Candera::Scenes.
                * - ThemeId: is the theme name (path) to be used. Views (Scenes) have to be unloaded before sending ThemeReqMsg. After receiving
                ThemeResMsg the Views (Scenes) have to be loaded again.
                For switching back to the default theme use an empty Courier::ItemId.
                <br> <br>
                Courier::ThemeResMsg is the corresponding response message.
                */
class ThemeReqMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ThemeReqMsg, ::Courier::Message, 0x6FA8B41E);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        ThemeReqMsg();
        ThemeReqMsg(::Courier::ItemId const & aThemeId);
        virtual ~ThemeReqMsg();

        ::Courier::ItemId const & GetThemeId() const { return mThemeId; }
        void SetThemeId(::Courier::ItemId const & value) { mThemeId = value; }

#if defined COURIER_MESSAGE_SERIALIZATION_ENABLED
        virtual const ::Courier::SerializationInfo * GetSerializationInfo() const;
#endif
    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mThemeReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mThemeReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mThemeReqMsgSubscriberList[];

        ::Courier::ItemId mThemeId;
};

/// @}

// ------------------------------------------------------------------------
/// @addtogroup COURIER_VISUALIZATION_MESSAGES
/// @{
                /** Result message which is sent after Courier::ThemeReqMsg is processed.
                * - Success indicates if setting of the theme name was successful or not.
                */
class ThemeResMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ThemeResMsg, ::Courier::Message, 0x609E163D);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(4);

        static bool Subscribe(::Courier::ComponentId component, ::Courier::ComponentId before = ::Courier::ComponentType::Invalid);
        static bool Unsubscribe(::Courier::ComponentId component);

        ThemeResMsg();
        ThemeResMsg(bool const & aSuccess);
        virtual ~ThemeResMsg();

        bool const & GetSuccess() const { return mSuccess; }
        void SetSuccess(bool const & value) { mSuccess = value; }

#if defined COURIER_MESSAGE_SERIALIZATION_ENABLED
        virtual const ::Courier::SerializationInfo * GetSerializationInfo() const;
#endif
    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mThemeResMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mThemeResMsgModifiableMetadata;
        static ::Courier::ComponentId mThemeResMsgSubscriberList[];

        ::Courier::ComponentId mSubscribers[SubscriberListSize];

        bool mSuccess;
};

/// @}

// ------------------------------------------------------------------------
/// @addtogroup COURIER_VISUALIZATION_MESSAGES
/// @{
                /** Executes operations on animations. Following operations are currently defined:
                * - (Start, "id", AnimationProperties) Starts an animation identified by 'id' using the AnimationProperties.
                * - (Stop, "id", *) Stops an animation identified by 'id'.
                * - (Finish, "id", AnimationProperties) Finishes an animation identified by 'id' using only the timeToFinish value.
                * - (Pause, "id", *)  Pauses an animation identified by 'id'.
                * - (Resume, "id", *) Resumes an animation identified by 'id'.
                * - (StopAll, *, *)  Stops all animations.
                <br> <br>
                * - ViewId: (only for local animations) specifies the view (scene) in which the animation is located (use ViewId("") or ViewId() for global animations).
                * - CompositePath: (only for local animations) the path to the composite in which the widget is located (use CompositePath("") or CompositePath() for global animations).
                * - AnimationId: the name of the animation.
                Courier::AnimationResMsg is the corresponding response message.
                Additional the asynchronous message Courier::AnimationIndMsg is sent after the animation has finished.
                An instance of AnimationProperties is always required even the properties are not used for the command.
                */
class AnimationReqMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(AnimationReqMsg, ::Courier::Message, 0x699B25AB);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        AnimationReqMsg();
        AnimationReqMsg(Courier::AnimationAction::Enum const & aAnimationAction, ::Courier::ViewId const & aViewId, Courier::CompositePath const & aCompositePath, ::Courier::ItemId const & aAnimationId, Courier::AnimationProperties const & aAnimationProperties);
        virtual ~AnimationReqMsg();

        Courier::AnimationAction::Enum const & GetAnimationAction() const { return mAnimationAction; }
        void SetAnimationAction(Courier::AnimationAction::Enum const & value) { mAnimationAction = value; }
        ::Courier::ViewId const & GetViewId() const { return mViewId; }
        void SetViewId(::Courier::ViewId const & value) { mViewId = value; }
        Courier::CompositePath const & GetCompositePath() const { return mCompositePath; }
        void SetCompositePath(Courier::CompositePath const & value) { mCompositePath = value; }
        ::Courier::ItemId const & GetAnimationId() const { return mAnimationId; }
        void SetAnimationId(::Courier::ItemId const & value) { mAnimationId = value; }
        Courier::AnimationProperties const & GetAnimationProperties() const { return mAnimationProperties; }
        void SetAnimationProperties(Courier::AnimationProperties const & value) { mAnimationProperties = value; }

#if defined COURIER_MESSAGE_SERIALIZATION_ENABLED
        virtual const ::Courier::SerializationInfo * GetSerializationInfo() const;
#endif
    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mAnimationReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mAnimationReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mAnimationReqMsgSubscriberList[];

        Courier::AnimationAction::Enum mAnimationAction;
        ::Courier::ViewId mViewId;
        Courier::CompositePath mCompositePath;
        ::Courier::ItemId mAnimationId;
        Courier::AnimationProperties mAnimationProperties;
};

/// @}

// ------------------------------------------------------------------------
/// @addtogroup COURIER_VISUALIZATION_MESSAGES
/// @{
                /** Result message which is sent after Courier::AnimationReqMsg is processed.
                * - AnimationAction, ViewId, CompositePath and AnimationId values corresponds to the used values of AnimationReqMsg.
                * - Success indicates if processing was successful or not.
                */
class AnimationResMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(AnimationResMsg, ::Courier::Message, 0x75F72190);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(4);

        static bool Subscribe(::Courier::ComponentId component, ::Courier::ComponentId before = ::Courier::ComponentType::Invalid);
        static bool Unsubscribe(::Courier::ComponentId component);

        AnimationResMsg();
        AnimationResMsg(Courier::AnimationAction::Enum const & aAnimationAction, ::Courier::ViewId const & aViewId, Courier::CompositePath const & aCompositePath, ::Courier::ItemId const & aAnimationId, bool const & aSuccess);
        virtual ~AnimationResMsg();

        Courier::AnimationAction::Enum const & GetAnimationAction() const { return mAnimationAction; }
        void SetAnimationAction(Courier::AnimationAction::Enum const & value) { mAnimationAction = value; }
        ::Courier::ViewId const & GetViewId() const { return mViewId; }
        void SetViewId(::Courier::ViewId const & value) { mViewId = value; }
        Courier::CompositePath const & GetCompositePath() const { return mCompositePath; }
        void SetCompositePath(Courier::CompositePath const & value) { mCompositePath = value; }
        ::Courier::ItemId const & GetAnimationId() const { return mAnimationId; }
        void SetAnimationId(::Courier::ItemId const & value) { mAnimationId = value; }
        bool const & GetSuccess() const { return mSuccess; }
        void SetSuccess(bool const & value) { mSuccess = value; }

#if defined COURIER_MESSAGE_SERIALIZATION_ENABLED
        virtual const ::Courier::SerializationInfo * GetSerializationInfo() const;
#endif
    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mAnimationResMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mAnimationResMsgModifiableMetadata;
        static ::Courier::ComponentId mAnimationResMsgSubscriberList[];

        ::Courier::ComponentId mSubscribers[SubscriberListSize];

        Courier::AnimationAction::Enum mAnimationAction;
        ::Courier::ViewId mViewId;
        Courier::CompositePath mCompositePath;
        ::Courier::ItemId mAnimationId;
        bool mSuccess;
};

/// @}

// ------------------------------------------------------------------------
/// @addtogroup COURIER_VISUALIZATION_MESSAGES
/// @{
                /** Asynchronous message which is sent after the animation has been finished.
                * - ViewId, CompositePath and AnimationId value corresponds to the used value of AnimationReqMsg.
                */
class AnimationIndMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(AnimationIndMsg, ::Courier::Message, 0x8E457B2A);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(4);

        static bool Subscribe(::Courier::ComponentId component, ::Courier::ComponentId before = ::Courier::ComponentType::Invalid);
        static bool Unsubscribe(::Courier::ComponentId component);

        AnimationIndMsg();
        AnimationIndMsg(::Courier::ViewId const & aViewId, Courier::CompositePath const & aCompositePath, ::Courier::ItemId const & aAnimationId);
        virtual ~AnimationIndMsg();

        ::Courier::ViewId const & GetViewId() const { return mViewId; }
        void SetViewId(::Courier::ViewId const & value) { mViewId = value; }
        Courier::CompositePath const & GetCompositePath() const { return mCompositePath; }
        void SetCompositePath(Courier::CompositePath const & value) { mCompositePath = value; }
        ::Courier::ItemId const & GetAnimationId() const { return mAnimationId; }
        void SetAnimationId(::Courier::ItemId const & value) { mAnimationId = value; }

#if defined COURIER_MESSAGE_SERIALIZATION_ENABLED
        virtual const ::Courier::SerializationInfo * GetSerializationInfo() const;
#endif
    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mAnimationIndMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mAnimationIndMsgModifiableMetadata;
        static ::Courier::ComponentId mAnimationIndMsgSubscriberList[];

        ::Courier::ComponentId mSubscribers[SubscriberListSize];

        ::Courier::ViewId mViewId;
        Courier::CompositePath mCompositePath;
        ::Courier::ItemId mAnimationId;
};

/// @}

// ------------------------------------------------------------------------
/// @addtogroup COURIER_VISUALIZATION_MESSAGES
/// @{
                /** Sets the value of a property of a widget.
                * - ViewId: the view (scene) which refers to the widget instances.
                * - CompositePath: the path to the composite in which the widget is located (use CompositePath("") or CompositePath() if the widget is located directly within a scene).
                * - WidgetId: the widget instance name for whom the property shall be set.
                * - PropertyId: the property id which shall be set.
                * - Value: the value which shall be set. Values always have to be strings, no type checks are done in Courier.
                <br> <br>
              Courier::SetPropertyResMsg is the corresponding response message.
              */
              // disable lint warnings for code generated SetPropertyReqMsg message classes
              FEATSTD_LINT_MESSAGE_STRING(1516, "FeatStd::Internal::AtomicOp::Atomic::mValue", "mValue member doesn't hide any base class member")
class SetPropertyReqMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(SetPropertyReqMsg, ::Courier::Message, 0x773F82BB);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        SetPropertyReqMsg();
        SetPropertyReqMsg(::Courier::ViewId const & aViewId, Courier::CompositePath const & aCompositePath, ::Courier::ItemId const & aWidgetId, ::Courier::ItemId const & aPropertyId, Courier::Payload const & aValue);
        virtual ~SetPropertyReqMsg();

        ::Courier::ViewId const & GetViewId() const { return mViewId; }
        void SetViewId(::Courier::ViewId const & value) { mViewId = value; }
        Courier::CompositePath const & GetCompositePath() const { return mCompositePath; }
        void SetCompositePath(Courier::CompositePath const & value) { mCompositePath = value; }
        ::Courier::ItemId const & GetWidgetId() const { return mWidgetId; }
        void SetWidgetId(::Courier::ItemId const & value) { mWidgetId = value; }
        ::Courier::ItemId const & GetPropertyId() const { return mPropertyId; }
        void SetPropertyId(::Courier::ItemId const & value) { mPropertyId = value; }
        Courier::Payload const & GetValue() const { return mValue; }
        void SetValue(Courier::Payload const & value) { mValue = value; }

#if defined COURIER_MESSAGE_SERIALIZATION_ENABLED
        virtual const ::Courier::SerializationInfo * GetSerializationInfo() const;
#endif
    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mSetPropertyReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mSetPropertyReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mSetPropertyReqMsgSubscriberList[];

        ::Courier::ViewId mViewId;
        Courier::CompositePath mCompositePath;
        ::Courier::ItemId mWidgetId;
        ::Courier::ItemId mPropertyId;
        Courier::Payload mValue;
};

/// @}

// ------------------------------------------------------------------------
/// @addtogroup COURIER_VISUALIZATION_MESSAGES
/// @{
                /** Result message which is sent after Courier::SetPropertyReqMsg is processed.
                * - ViewId, CompositePath, WidgetId and PropertyId values corresponds to the used values of SetPropertyReqMsg.
                * - Success indicates if setting of the value was successful or not.
                */
class SetPropertyResMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(SetPropertyResMsg, ::Courier::Message, 0xFF38A766);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(4);

        static bool Subscribe(::Courier::ComponentId component, ::Courier::ComponentId before = ::Courier::ComponentType::Invalid);
        static bool Unsubscribe(::Courier::ComponentId component);

        SetPropertyResMsg();
        SetPropertyResMsg(::Courier::ViewId const & aViewId, Courier::CompositePath const & aCompositePath, ::Courier::ItemId const & aWidgetId, ::Courier::ItemId const & aPropertyId, bool const & aSuccess);
        virtual ~SetPropertyResMsg();

        ::Courier::ViewId const & GetViewId() const { return mViewId; }
        void SetViewId(::Courier::ViewId const & value) { mViewId = value; }
        Courier::CompositePath const & GetCompositePath() const { return mCompositePath; }
        void SetCompositePath(Courier::CompositePath const & value) { mCompositePath = value; }
        ::Courier::ItemId const & GetWidgetId() const { return mWidgetId; }
        void SetWidgetId(::Courier::ItemId const & value) { mWidgetId = value; }
        ::Courier::ItemId const & GetPropertyId() const { return mPropertyId; }
        void SetPropertyId(::Courier::ItemId const & value) { mPropertyId = value; }
        bool const & GetSuccess() const { return mSuccess; }
        void SetSuccess(bool const & value) { mSuccess = value; }

#if defined COURIER_MESSAGE_SERIALIZATION_ENABLED
        virtual const ::Courier::SerializationInfo * GetSerializationInfo() const;
#endif
    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mSetPropertyResMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mSetPropertyResMsgModifiableMetadata;
        static ::Courier::ComponentId mSetPropertyResMsgSubscriberList[];

        ::Courier::ComponentId mSubscribers[SubscriberListSize];

        ::Courier::ViewId mViewId;
        Courier::CompositePath mCompositePath;
        ::Courier::ItemId mWidgetId;
        ::Courier::ItemId mPropertyId;
        bool mSuccess;
};

/// @}

// ------------------------------------------------------------------------
/// @addtogroup COURIER_VISUALIZATION_MESSAGES
/// @{
                /** Sets the focus to the specified widget of a view.
                * - ViewId: the view (scene) which refers to the widget instances.
                * - CompositePath: the path to the composite in which the widget is located (use CompositePath("") or CompositePath() if the widget is located directly within a scene).
                * - WidgetId: the widget instance name of the focused widget.
                <br> <br>
                Courier::SetFocusResMsg is the corresponding response message.
                */
class SetFocusReqMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(SetFocusReqMsg, ::Courier::Message, 0xB2820010);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        SetFocusReqMsg();
        SetFocusReqMsg(::Courier::ViewId const & aViewId, Courier::CompositePath const & aCompositePath, ::Courier::ItemId const & aWidgetId);
        virtual ~SetFocusReqMsg();

        ::Courier::ViewId const & GetViewId() const { return mViewId; }
        void SetViewId(::Courier::ViewId const & value) { mViewId = value; }
        Courier::CompositePath const & GetCompositePath() const { return mCompositePath; }
        void SetCompositePath(Courier::CompositePath const & value) { mCompositePath = value; }
        ::Courier::ItemId const & GetWidgetId() const { return mWidgetId; }
        void SetWidgetId(::Courier::ItemId const & value) { mWidgetId = value; }

#if defined COURIER_MESSAGE_SERIALIZATION_ENABLED
        virtual const ::Courier::SerializationInfo * GetSerializationInfo() const;
#endif
    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mSetFocusReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mSetFocusReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mSetFocusReqMsgSubscriberList[];

        ::Courier::ViewId mViewId;
        Courier::CompositePath mCompositePath;
        ::Courier::ItemId mWidgetId;
};

/// @}

// ------------------------------------------------------------------------
/// @addtogroup COURIER_VISUALIZATION_MESSAGES
/// @{
                /** Result message which is sent after Courier::SetFocusReqMsg is processed.
                * - ViewId, CompositePath and WidgetId values corresponds to the used values of SetFocusReqMsg.
                * - Success indicates if the fousing of the widget was successful or not.
                */
class SetFocusResMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(SetFocusResMsg, ::Courier::Message, 0x0EE90EF8);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(4);

        static bool Subscribe(::Courier::ComponentId component, ::Courier::ComponentId before = ::Courier::ComponentType::Invalid);
        static bool Unsubscribe(::Courier::ComponentId component);

        SetFocusResMsg();
        SetFocusResMsg(::Courier::ViewId const & aViewId, Courier::CompositePath const & aCompositePath, ::Courier::ItemId const & aWidgetId, bool const & aSuccess);
        virtual ~SetFocusResMsg();

        ::Courier::ViewId const & GetViewId() const { return mViewId; }
        void SetViewId(::Courier::ViewId const & value) { mViewId = value; }
        Courier::CompositePath const & GetCompositePath() const { return mCompositePath; }
        void SetCompositePath(Courier::CompositePath const & value) { mCompositePath = value; }
        ::Courier::ItemId const & GetWidgetId() const { return mWidgetId; }
        void SetWidgetId(::Courier::ItemId const & value) { mWidgetId = value; }
        bool const & GetSuccess() const { return mSuccess; }
        void SetSuccess(bool const & value) { mSuccess = value; }

#if defined COURIER_MESSAGE_SERIALIZATION_ENABLED
        virtual const ::Courier::SerializationInfo * GetSerializationInfo() const;
#endif
    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mSetFocusResMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mSetFocusResMsgModifiableMetadata;
        static ::Courier::ComponentId mSetFocusResMsgSubscriberList[];

        ::Courier::ComponentId mSubscribers[SubscriberListSize];

        ::Courier::ViewId mViewId;
        Courier::CompositePath mCompositePath;
        ::Courier::ItemId mWidgetId;
        bool mSuccess;
};

/// @}

// ------------------------------------------------------------------------
/// @addtogroup COURIER_VISUALIZATION_MESSAGES
/// @{
                /** Indicates which previous focused widget has lost the focus.
                * - ViewId, CompositePath and WidgetId values idnicates which widget/view has lost the focus.
                */
class LostFocusIndMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(LostFocusIndMsg, ::Courier::Message, 0xE5D4D60F);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(4);

        static bool Subscribe(::Courier::ComponentId component, ::Courier::ComponentId before = ::Courier::ComponentType::Invalid);
        static bool Unsubscribe(::Courier::ComponentId component);

        LostFocusIndMsg();
        LostFocusIndMsg(::Courier::ViewId const & aViewId, Courier::CompositePath const & aCompositePath, ::Courier::ItemId const & aWidgetId);
        virtual ~LostFocusIndMsg();

        ::Courier::ViewId const & GetViewId() const { return mViewId; }
        void SetViewId(::Courier::ViewId const & value) { mViewId = value; }
        Courier::CompositePath const & GetCompositePath() const { return mCompositePath; }
        void SetCompositePath(Courier::CompositePath const & value) { mCompositePath = value; }
        ::Courier::ItemId const & GetWidgetId() const { return mWidgetId; }
        void SetWidgetId(::Courier::ItemId const & value) { mWidgetId = value; }

#if defined COURIER_MESSAGE_SERIALIZATION_ENABLED
        virtual const ::Courier::SerializationInfo * GetSerializationInfo() const;
#endif
    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mLostFocusIndMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mLostFocusIndMsgModifiableMetadata;
        static ::Courier::ComponentId mLostFocusIndMsgSubscriberList[];

        ::Courier::ComponentId mSubscribers[SubscriberListSize];

        ::Courier::ViewId mViewId;
        Courier::CompositePath mCompositePath;
        ::Courier::ItemId mWidgetId;
};

/// @}

// ------------------------------------------------------------------------
/// @addtogroup COURIER_VISUALIZATION_MESSAGES
/// @{
                /** Executes transitions. Following operations are currently defined:
                * - (Start, "id", firstView, secondView, payload) Starts a transition of type 'id' using firstView and secondView using an
                optional payload string, which might be used by the concrete transition implementation (e.g. variable time span of a transition).
                * - (Reset, "id", *, *, *) Resets the current transition and implemented transition shall reset to start state.
                * - (Finish, "id", *, *, *) Finishes the transition, which means it jumps to the end.
                <br> <br>
                Courier::TransitionResMsg is the corresponding response message.
                Additional the asynchronous message Courier::TransitionIndMsg is sent after the transition has finished.
                */
class TransitionReqMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(TransitionReqMsg, ::Courier::Message, 0x406D3EA9);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        TransitionReqMsg();
        TransitionReqMsg(Courier::TransitionAction::Enum const & aTransitionAction, ::Courier::ItemId const & aTransitionId, ::Courier::ViewId const & aFirstViewId, ::Courier::ViewId const & aSecondViewId, Courier::Payload const & aOptionalPayload);
        virtual ~TransitionReqMsg();

        Courier::TransitionAction::Enum const & GetTransitionAction() const { return mTransitionAction; }
        void SetTransitionAction(Courier::TransitionAction::Enum const & value) { mTransitionAction = value; }
        ::Courier::ItemId const & GetTransitionId() const { return mTransitionId; }
        void SetTransitionId(::Courier::ItemId const & value) { mTransitionId = value; }
        ::Courier::ViewId const & GetFirstViewId() const { return mFirstViewId; }
        void SetFirstViewId(::Courier::ViewId const & value) { mFirstViewId = value; }
        ::Courier::ViewId const & GetSecondViewId() const { return mSecondViewId; }
        void SetSecondViewId(::Courier::ViewId const & value) { mSecondViewId = value; }
        Courier::Payload const & GetOptionalPayload() const { return mOptionalPayload; }
        void SetOptionalPayload(Courier::Payload const & value) { mOptionalPayload = value; }

#if defined COURIER_MESSAGE_SERIALIZATION_ENABLED
        virtual const ::Courier::SerializationInfo * GetSerializationInfo() const;
#endif
    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mTransitionReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mTransitionReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mTransitionReqMsgSubscriberList[];

        Courier::TransitionAction::Enum mTransitionAction;
        ::Courier::ItemId mTransitionId;
        ::Courier::ViewId mFirstViewId;
        ::Courier::ViewId mSecondViewId;
        Courier::Payload mOptionalPayload;
};

/// @}

// ------------------------------------------------------------------------
/// @addtogroup COURIER_VISUALIZATION_MESSAGES
/// @{
                /** Result message which is sent after Courier::TransitionReqMsg is processed.
                * - TransitionAction, TransitionId, FirstViewId and SecondViewId values correspond to the used values of TransitionReqMsg.
                * - Success indicates if processing was successful or not.
                */
class TransitionResMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(TransitionResMsg, ::Courier::Message, 0x0C47D087);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(4);

        static bool Subscribe(::Courier::ComponentId component, ::Courier::ComponentId before = ::Courier::ComponentType::Invalid);
        static bool Unsubscribe(::Courier::ComponentId component);

        TransitionResMsg();
        TransitionResMsg(Courier::TransitionAction::Enum const & aTransitionAction, ::Courier::ItemId const & aTransitionId, ::Courier::ViewId const & aFirstViewId, ::Courier::ViewId const & aSecondViewId, bool const & aSuccess);
        virtual ~TransitionResMsg();

        Courier::TransitionAction::Enum const & GetTransitionAction() const { return mTransitionAction; }
        void SetTransitionAction(Courier::TransitionAction::Enum const & value) { mTransitionAction = value; }
        ::Courier::ItemId const & GetTransitionId() const { return mTransitionId; }
        void SetTransitionId(::Courier::ItemId const & value) { mTransitionId = value; }
        ::Courier::ViewId const & GetFirstViewId() const { return mFirstViewId; }
        void SetFirstViewId(::Courier::ViewId const & value) { mFirstViewId = value; }
        ::Courier::ViewId const & GetSecondViewId() const { return mSecondViewId; }
        void SetSecondViewId(::Courier::ViewId const & value) { mSecondViewId = value; }
        bool const & GetSuccess() const { return mSuccess; }
        void SetSuccess(bool const & value) { mSuccess = value; }

#if defined COURIER_MESSAGE_SERIALIZATION_ENABLED
        virtual const ::Courier::SerializationInfo * GetSerializationInfo() const;
#endif
    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mTransitionResMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mTransitionResMsgModifiableMetadata;
        static ::Courier::ComponentId mTransitionResMsgSubscriberList[];

        ::Courier::ComponentId mSubscribers[SubscriberListSize];

        Courier::TransitionAction::Enum mTransitionAction;
        ::Courier::ItemId mTransitionId;
        ::Courier::ViewId mFirstViewId;
        ::Courier::ViewId mSecondViewId;
        bool mSuccess;
};

/// @}

// ------------------------------------------------------------------------
/// @addtogroup COURIER_VISUALIZATION_MESSAGES
/// @{
                /** Asynchronous message which is sent after the transition has been finished.
                * - TransitionId, FirstViewId and SecondViewId values correspond to the used values of TransitionReqMsg.
                * - Reset indicates if the transition was finished or the transition was reset.
                */
class TransitionIndMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(TransitionIndMsg, ::Courier::Message, 0xC7B455FB);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(4);

        static bool Subscribe(::Courier::ComponentId component, ::Courier::ComponentId before = ::Courier::ComponentType::Invalid);
        static bool Unsubscribe(::Courier::ComponentId component);

        TransitionIndMsg();
        TransitionIndMsg(::Courier::ItemId const & aTransitionId, ::Courier::ViewId const & aFirstViewId, ::Courier::ViewId const & aSecondViewId, bool const & aReset);
        virtual ~TransitionIndMsg();

        ::Courier::ItemId const & GetTransitionId() const { return mTransitionId; }
        void SetTransitionId(::Courier::ItemId const & value) { mTransitionId = value; }
        ::Courier::ViewId const & GetFirstViewId() const { return mFirstViewId; }
        void SetFirstViewId(::Courier::ViewId const & value) { mFirstViewId = value; }
        ::Courier::ViewId const & GetSecondViewId() const { return mSecondViewId; }
        void SetSecondViewId(::Courier::ViewId const & value) { mSecondViewId = value; }
        bool const & GetReset() const { return mReset; }
        void SetReset(bool const & value) { mReset = value; }

#if defined COURIER_MESSAGE_SERIALIZATION_ENABLED
        virtual const ::Courier::SerializationInfo * GetSerializationInfo() const;
#endif
    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mTransitionIndMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mTransitionIndMsgModifiableMetadata;
        static ::Courier::ComponentId mTransitionIndMsgSubscriberList[];

        ::Courier::ComponentId mSubscribers[SubscriberListSize];

        ::Courier::ItemId mTransitionId;
        ::Courier::ViewId mFirstViewId;
        ::Courier::ViewId mSecondViewId;
        bool mReset;
};

/// @}

// ------------------------------------------------------------------------
/// @addtogroup COURIER_VISUALIZATION_MESSAGES
/// @{
                /** Invalidates the cameras of the given View/Scene.
                */
class InvalidateReqMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(InvalidateReqMsg, ::Courier::Message, 0xC2001149);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        InvalidateReqMsg();
        InvalidateReqMsg(::Courier::ViewId const & aViewId);
        virtual ~InvalidateReqMsg();

        ::Courier::ViewId const & GetViewId() const { return mViewId; }
        void SetViewId(::Courier::ViewId const & value) { mViewId = value; }

#if defined COURIER_MESSAGE_SERIALIZATION_ENABLED
        virtual const ::Courier::SerializationInfo * GetSerializationInfo() const;
#endif
    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mInvalidateReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mInvalidateReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mInvalidateReqMsgSubscriberList[];

        ::Courier::ViewId mViewId;
};

/// @}

// ------------------------------------------------------------------------
/// @addtogroup COURIER_VISUALIZATION_MESSAGES
/// @{
                /** Causes a message triggered render request:
                * Invalidates all enabled Views / Cameras.
                * - RenderAll: this flag indicates that all (not only caused by invalidating Views) rendertargets shall be in invalidated.
                <br> <br>
                Courier::RenderResMsg is the corresponding response message.
                */
class RenderReqMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(RenderReqMsg, ::Courier::Message, 0x7567683A);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(3);

        RenderReqMsg();
        RenderReqMsg(bool const & aRenderAll);
        virtual ~RenderReqMsg();

        bool const & GetRenderAll() const { return mRenderAll; }
        void SetRenderAll(bool const & value) { mRenderAll = value; }

#if defined COURIER_MESSAGE_SERIALIZATION_ENABLED
        virtual const ::Courier::SerializationInfo * GetSerializationInfo() const;
#endif
    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mRenderReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mRenderReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mRenderReqMsgSubscriberList[];

        bool mRenderAll;
};

/// @}

// ------------------------------------------------------------------------
/// @addtogroup COURIER_VISUALIZATION_MESSAGES
/// @{
                /** Result message which is sent after Courier::RenderReqMsg is processed.
                * - ComponentId: is the component id of the RenderComponent which processed the request.
                * - Success: indicates if invalidating was successful or not.
                */
class RenderResMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(RenderResMsg, ::Courier::Message, 0x43203E80);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(4);

        static bool Subscribe(::Courier::ComponentId component, ::Courier::ComponentId before = ::Courier::ComponentType::Invalid);
        static bool Unsubscribe(::Courier::ComponentId component);

        RenderResMsg();
        RenderResMsg(Courier::ComponentId const & aComponentId, bool const & aSuccess);
        virtual ~RenderResMsg();

        Courier::ComponentId const & GetComponentId() const { return mComponentId; }
        void SetComponentId(Courier::ComponentId const & value) { mComponentId = value; }
        bool const & GetSuccess() const { return mSuccess; }
        void SetSuccess(bool const & value) { mSuccess = value; }

#if defined COURIER_MESSAGE_SERIALIZATION_ENABLED
        virtual const ::Courier::SerializationInfo * GetSerializationInfo() const;
#endif
    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mRenderResMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mRenderResMsgModifiableMetadata;
        static ::Courier::ComponentId mRenderResMsgSubscriberList[];

        ::Courier::ComponentId mSubscribers[SubscriberListSize];

        Courier::ComponentId mComponentId;
        bool mSuccess;
};

/// @}

// ------------------------------------------------------------------------
/// @addtogroup COURIER_VISUALIZATION_MESSAGES
/// @{
                /** Enables or disables a Candera::RenderTarget layer:
                * - Layer: the layer id.
                * - Activate: the flag which indicates if the layer shall be activated or deactivated.
                <br> <br>
                Courier::LayerResMsg is the corresponding response message.
                */
class LayerReqMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(LayerReqMsg, ::Courier::Message, 0xB17B6A80);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(3);

        LayerReqMsg();
        LayerReqMsg(Courier::Int const & aLayer, bool const & aActivate);
        virtual ~LayerReqMsg();

        Courier::Int const & GetLayer() const { return mLayer; }
        void SetLayer(Courier::Int const & value) { mLayer = value; }
        bool const & GetActivate() const { return mActivate; }
        void SetActivate(bool const & value) { mActivate = value; }

#if defined COURIER_MESSAGE_SERIALIZATION_ENABLED
        virtual const ::Courier::SerializationInfo * GetSerializationInfo() const;
#endif
    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mLayerReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mLayerReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mLayerReqMsgSubscriberList[];

        Courier::Int mLayer;
        bool mActivate;
};

/// @}

// ------------------------------------------------------------------------
/// @addtogroup COURIER_VISUALIZATION_MESSAGES
/// @{
                /** Result message which is sent after Courier::LayerReqMsg is processed.
                * - ComponentId: is the component id of the RenderComponent which processed the request.
                * - Success: indicates if activating/deactivating was successful or not.
                */
class LayerResMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(LayerResMsg, ::Courier::Message, 0x21A5FA73);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(4);

        static bool Subscribe(::Courier::ComponentId component, ::Courier::ComponentId before = ::Courier::ComponentType::Invalid);
        static bool Unsubscribe(::Courier::ComponentId component);

        LayerResMsg();
        LayerResMsg(Courier::ComponentId const & aComponentId, bool const & aSuccess);
        virtual ~LayerResMsg();

        Courier::ComponentId const & GetComponentId() const { return mComponentId; }
        void SetComponentId(Courier::ComponentId const & value) { mComponentId = value; }
        bool const & GetSuccess() const { return mSuccess; }
        void SetSuccess(bool const & value) { mSuccess = value; }

#if defined COURIER_MESSAGE_SERIALIZATION_ENABLED
        virtual const ::Courier::SerializationInfo * GetSerializationInfo() const;
#endif
    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mLayerResMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mLayerResMsgModifiableMetadata;
        static ::Courier::ComponentId mLayerResMsgSubscriberList[];

        ::Courier::ComponentId mSubscribers[SubscriberListSize];

        Courier::ComponentId mComponentId;
        bool mSuccess;
};

/// @}

// ------------------------------------------------------------------------
/// @addtogroup COURIER_VISUALIZATION_MESSAGES
/// @{
                /** Deprecated, was for internal use only.
                */
class RenderWakeUpMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(RenderWakeUpMsg, ::Courier::Message, 0x89B1620B);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(3);

        RenderWakeUpMsg();
        virtual ~RenderWakeUpMsg();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mRenderWakeUpMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mRenderWakeUpMsgModifiableMetadata;
        static const ::Courier::ComponentId mRenderWakeUpMsgSubscriberList[];
};

/// @}

// ------------------------------------------------------------------------
/// @addtogroup COURIER_VISUALIZATION_MESSAGES
/// @{
                /** Event (message) which is sent to the FrameworkWidgets and ViewController of the View when it gets activated or deactivated.
                * - Activated: returns if the view gets activated or it was deactivated.
                */
class ParentViewActivateEvent : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ParentViewActivateEvent, ::Courier::Message, 0x4769EC87);

        ParentViewActivateEvent(bool const & aActivated);
        virtual ~ParentViewActivateEvent();

        bool const & GetActivated() const { return mactivated; }
        void SetActivated(bool const & value) { mactivated = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(ParentViewActivateEvent);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mParentViewActivateEventMetaData;
        static ::Courier::Message::ModifiableMetadata mParentViewActivateEventModifiableMetadata;

        bool mactivated;
};

/// @}

// ------------------------------------------------------------------------
/// @addtogroup COURIER_VISUALIZATION_MESSAGES
/// @{
                /** Event (message) which is sent to the FrameworkWidgets and ViewController of the View when the rendering of the views cameras gets enabled or disabled.
                * - Enabled: returns if the views rendering is enabled or disabled.
                */
class ParentViewRenderingEnabledEvent : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ParentViewRenderingEnabledEvent, ::Courier::Message, 0x3EEBE896);

        ParentViewRenderingEnabledEvent(bool const & aEnabled);
        virtual ~ParentViewRenderingEnabledEvent();

        bool const & GetEnabled() const { return menabled; }
        void SetEnabled(bool const & value) { menabled = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(ParentViewRenderingEnabledEvent);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mParentViewRenderingEnabledEventMetaData;
        static ::Courier::Message::ModifiableMetadata mParentViewRenderingEnabledEventModifiableMetadata;

        bool menabled;
};

/// @}

// ------------------------------------------------------------------------
/// @addtogroup COURIER_VISUALIZATION_MESSAGES
/// @{
                /** Event (message) which is sent to the FrameworkWidgets and ViewController of the View when the scenecontext, cameras and widgets are created or destroyed.
                * - Loaded: returns if the view content was created or destroyed.
                */
class ParentViewInitContentEvent : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ParentViewInitContentEvent, ::Courier::Message, 0xECC6BA8C);

        ParentViewInitContentEvent(bool const & aLoaded);
        virtual ~ParentViewInitContentEvent();

        bool const & GetLoaded() const { return mloaded; }
        void SetLoaded(bool const & value) { mloaded = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(ParentViewInitContentEvent);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mParentViewInitContentEventMetaData;
        static ::Courier::Message::ModifiableMetadata mParentViewInitContentEventModifiableMetadata;

        bool mloaded;
};

/// @}

// ------------------------------------------------------------------------
/// @addtogroup COURIER_VISUALIZATION_MESSAGES
/// @{
                /** Event (message) which is sent to the FrameworkWidgets and ViewController of the View when the scene is uploaded or unloaded.
                * - Loaded: returns if the view was uploaded or unloaded.
                */
class ParentViewLoadEvent : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ParentViewLoadEvent, ::Courier::Message, 0xBB33AF45);

        ParentViewLoadEvent(bool const & aLoaded);
        virtual ~ParentViewLoadEvent();

        bool const & GetLoaded() const { return mloaded; }
        void SetLoaded(bool const & value) { mloaded = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(ParentViewLoadEvent);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mParentViewLoadEventMetaData;
        static ::Courier::Message::ModifiableMetadata mParentViewLoadEventModifiableMetadata;

        bool mloaded;
};

/// @}

// ------------------------------------------------------------------------
/// @addtogroup COURIER_VISUALIZATION_MESSAGES
/// @{
                /** Event (message) which is sent to the FrameworkWidget which get the focus.
                */
class FocusEvent : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(FocusEvent, ::Courier::Message, 0x153856D5);

        FocusEvent();
        virtual ~FocusEvent();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mFocusEventMetaData;
        static ::Courier::Message::ModifiableMetadata mFocusEventModifiableMetadata;
};

/// @}

// ------------------------------------------------------------------------
/// @addtogroup COURIER_VISUALIZATION_MESSAGES
/// @{
                /** Event (message) which is sent to the FrameworkWidget which will lose the focus.
                */
class LostFocusEvent : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(LostFocusEvent, ::Courier::Message, 0x953E951F);

        LostFocusEvent();
        virtual ~LostFocusEvent();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mLostFocusEventMetaData;
        static ::Courier::Message::ModifiableMetadata mLostFocusEventModifiableMetadata;
};

/// @}

// ------------------------------------------------------------------------
/// @addtogroup COURIER_VISUALIZATION_MESSAGES
/// @{
                /** Event (message) which is sent to the FrameworkWidgets of the FirstView and SecondView when the transition is started.
                */
class TransitionStartedEvent : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(TransitionStartedEvent, ::Courier::Message, 0x9963F873);

        TransitionStartedEvent(Courier::View::Ptr const & aFirstView, Courier::View::Ptr const & aSecondView);
        virtual ~TransitionStartedEvent();

        Courier::View::Ptr const & GetFirstView() const { return mFirstView; }
        void SetFirstView(Courier::View::Ptr const & value) { mFirstView = value; }
        Courier::View::Ptr const & GetSecondView() const { return mSecondView; }
        void SetSecondView(Courier::View::Ptr const & value) { mSecondView = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(TransitionStartedEvent);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mTransitionStartedEventMetaData;
        static ::Courier::Message::ModifiableMetadata mTransitionStartedEventModifiableMetadata;

        Courier::View::Ptr mFirstView;
        Courier::View::Ptr mSecondView;
};

/// @}

// ------------------------------------------------------------------------
/// @addtogroup COURIER_VISUALIZATION_MESSAGES
/// @{
                /** Event (message) which is sent to the FrameworkWidgets of the FirstView and SecondView when the transition is finished.
                * - WasReset: returns if the transition was reset.
                */
class TransitionFinishedEvent : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(TransitionFinishedEvent, ::Courier::Message, 0xC7CC2113);

        TransitionFinishedEvent(Courier::View::Ptr const & aFirstView, Courier::View::Ptr const & aSecondView, bool const & aWasReset);
        virtual ~TransitionFinishedEvent();

        Courier::View::Ptr const & GetFirstView() const { return mFirstView; }
        void SetFirstView(Courier::View::Ptr const & value) { mFirstView = value; }
        Courier::View::Ptr const & GetSecondView() const { return mSecondView; }
        void SetSecondView(Courier::View::Ptr const & value) { mSecondView = value; }
        bool const & GetWasReset() const { return mWasReset; }
        void SetWasReset(bool const & value) { mWasReset = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(TransitionFinishedEvent);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mTransitionFinishedEventMetaData;
        static ::Courier::Message::ModifiableMetadata mTransitionFinishedEventModifiableMetadata;

        Courier::View::Ptr mFirstView;
        Courier::View::Ptr mSecondView;
        bool mWasReset;
};

/// @}

// ------------------------------------------------------------------------
/// @addtogroup COURIER_VISUALIZATION_MESSAGES
/// @{
                /** Message for changing the culture.
                <br> <br>
                Courier::CultureResMsg is the corresponding response message.
                */
class SetCultureReqMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(SetCultureReqMsg, ::Courier::Message, 0xB23FB08A);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        SetCultureReqMsg();
        SetCultureReqMsg(::Courier::ItemId const & aLocale);
        virtual ~SetCultureReqMsg();

        ::Courier::ItemId const & GetLocale() const { return mLocale; }
        void SetLocale(::Courier::ItemId const & value) { mLocale = value; }

#if defined COURIER_MESSAGE_SERIALIZATION_ENABLED
        virtual const ::Courier::SerializationInfo * GetSerializationInfo() const;
#endif
    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mSetCultureReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mSetCultureReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mSetCultureReqMsgSubscriberList[];

        ::Courier::ItemId mLocale;
};

/// @}

// ------------------------------------------------------------------------
/// @addtogroup COURIER_VISUALIZATION_MESSAGES
/// @{
                /** Result message which is sent after Courier::SetCultureReqMsg is processed.
                * - Success indicates if processing was successful or not.
                */
class SetCultureResMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(SetCultureResMsg, ::Courier::Message, 0x9B49B089);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(4);

        static bool Subscribe(::Courier::ComponentId component, ::Courier::ComponentId before = ::Courier::ComponentType::Invalid);
        static bool Unsubscribe(::Courier::ComponentId component);

        SetCultureResMsg();
        SetCultureResMsg(bool const & aSuccess);
        virtual ~SetCultureResMsg();

        bool const & GetSuccess() const { return mSuccess; }
        void SetSuccess(bool const & value) { mSuccess = value; }

#if defined COURIER_MESSAGE_SERIALIZATION_ENABLED
        virtual const ::Courier::SerializationInfo * GetSerializationInfo() const;
#endif
    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mSetCultureResMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mSetCultureResMsgModifiableMetadata;
        static ::Courier::ComponentId mSetCultureResMsgSubscriberList[];

        ::Courier::ComponentId mSubscribers[SubscriberListSize];

        bool mSuccess;
};

/// @}

// ------------------------------------------------------------------------
/// @addtogroup COURIER_VISUALIZATION_MESSAGES
/// @{
                /** Message sent in case the Culture was changed.
                * - CulturePtr: is a shared pointer to the Culture object.
                */
class CultureChangeIndMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(CultureChangeIndMsg, ::Courier::Message, 0x1D3C43B5);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(4);

        static bool Subscribe(::Courier::ComponentId component, ::Courier::ComponentId before = ::Courier::ComponentType::Invalid);
        static bool Unsubscribe(::Courier::ComponentId component);

        CultureChangeIndMsg();
        CultureChangeIndMsg(Candera::Globalization::Culture::SharedPointer const & aCulturePtr);
        virtual ~CultureChangeIndMsg();

        Candera::Globalization::Culture::SharedPointer const & GetCulturePtr() const { return mCulturePtr; }
        void SetCulturePtr(Candera::Globalization::Culture::SharedPointer const & value) { mCulturePtr = value; }

#if defined COURIER_MESSAGE_SERIALIZATION_ENABLED
        virtual const ::Courier::SerializationInfo * GetSerializationInfo() const;
#endif
    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mCultureChangeIndMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mCultureChangeIndMsgModifiableMetadata;
        static ::Courier::ComponentId mCultureChangeIndMsgSubscriberList[];

        ::Courier::ComponentId mSubscribers[SubscriberListSize];

        Candera::Globalization::Culture::SharedPointer mCulturePtr;
};

/// @}

// ------------------------------------------------------------------------
/// @addtogroup COURIER_VISUALIZATION
/// @{
                /** Takes care of creating, handling (loading/unloading) and destroying placeholder objects for views, which controls the loading/unloading of render targets associated with the cameras of the views.
                * - ViewId: the Id of the view for which corresponding render targets must be controlled.
                * - Load: this flag controls if the placeholder object should be loaded/ unloade.
                <br> <br>
                Courier::ViewPlaceholderResMsg is the corresponding response message.
                */
class ViewPlaceholderReqMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ViewPlaceholderReqMsg, ::Courier::Message, 0xADF4A272);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        ViewPlaceholderReqMsg();
        ViewPlaceholderReqMsg(::Courier::ViewId const & aViewId, bool const & aLoad);
        virtual ~ViewPlaceholderReqMsg();

        ::Courier::ViewId const & GetViewId() const { return mViewId; }
        void SetViewId(::Courier::ViewId const & value) { mViewId = value; }
        bool const & GetLoad() const { return mLoad; }
        void SetLoad(bool const & value) { mLoad = value; }

#if defined COURIER_MESSAGE_SERIALIZATION_ENABLED
        virtual const ::Courier::SerializationInfo * GetSerializationInfo() const;
#endif
    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mViewPlaceholderReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mViewPlaceholderReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mViewPlaceholderReqMsgSubscriberList[];

        ::Courier::ViewId mViewId;
        bool mLoad;
};

/// @}

// ------------------------------------------------------------------------
/// @addtogroup COURIER_VISUALIZATION
/// @{
                /** Result message which is sent after Courier::ViewPlaceholderReqMsg is processed.
                * - Load if the request was a load or unload request.
                * - Success indicates if loading/unloading was successful or not.
                * - LoadError indicates the type of loading error.
                */
class ViewPlaceholderResMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ViewPlaceholderResMsg, ::Courier::Message, 0x4859ADAF);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(4);

        static bool Subscribe(::Courier::ComponentId component, ::Courier::ComponentId before = ::Courier::ComponentType::Invalid);
        static bool Unsubscribe(::Courier::ComponentId component);

        ViewPlaceholderResMsg();
        ViewPlaceholderResMsg(bool const & aLoad, bool const & aSuccess, Courier::ViewPlaceholderLoadError const & aLoadError);
        virtual ~ViewPlaceholderResMsg();

        bool const & GetLoad() const { return mLoad; }
        void SetLoad(bool const & value) { mLoad = value; }
        bool const & GetSuccess() const { return mSuccess; }
        void SetSuccess(bool const & value) { mSuccess = value; }
        Courier::ViewPlaceholderLoadError const & GetLoadError() const { return mLoadError; }
        void SetLoadError(Courier::ViewPlaceholderLoadError const & value) { mLoadError = value; }

#if defined COURIER_MESSAGE_SERIALIZATION_ENABLED
        virtual const ::Courier::SerializationInfo * GetSerializationInfo() const;
#endif
    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mViewPlaceholderResMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mViewPlaceholderResMsgModifiableMetadata;
        static ::Courier::ComponentId mViewPlaceholderResMsgSubscriberList[];

        ::Courier::ComponentId mSubscribers[SubscriberListSize];

        bool mLoad;
        bool mSuccess;
        Courier::ViewPlaceholderLoadError mLoadError;
};

/// @}

// ------------------------------------------------------------------------
/// @addtogroup COURIER_VISUALIZATION_MESSAGES
/// @{
                    /** Base class which shall be used when defining messages which shall be sent directly to a view.
                    */
class ViewMsgBase : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ViewMsgBase, ::Courier::Message, 0x4ACEA666);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        ViewMsgBase();
        ViewMsgBase(::Courier::ViewId const & aViewId);
        virtual ~ViewMsgBase();

        ::Courier::ViewId const & GetViewId() const { return mViewId; }
        void SetViewId(::Courier::ViewId const & value) { mViewId = value; }

#if defined COURIER_MESSAGE_SERIALIZATION_ENABLED
        virtual const ::Courier::SerializationInfo * GetSerializationInfo() const;
#endif
    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mViewMsgBaseMetaData;
        static ::Courier::Message::ModifiableMetadata mViewMsgBaseModifiableMetadata;
        static const ::Courier::ComponentId mViewMsgBaseSubscriberList[];

        ::Courier::ViewId mViewId;
};

/// @}

// ------------------------------------------------------------------------
/// @addtogroup COURIER_VISUALIZATION_MESSAGES
/// @{
                    /** Base class which shall be used when defining messages which shall be sent directly to a widget.
                    */
class WidgetMsgBase : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(WidgetMsgBase, ::Courier::Message, 0x102CA089);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        WidgetMsgBase();
        WidgetMsgBase(::Courier::ViewId const & aViewId, Courier::CompositePath const & aCompositePath, ::Courier::ItemId const & aItemId);
        virtual ~WidgetMsgBase();

        ::Courier::ViewId const & GetViewId() const { return mViewId; }
        void SetViewId(::Courier::ViewId const & value) { mViewId = value; }
        Courier::CompositePath const & GetCompositePath() const { return mCompositePath; }
        void SetCompositePath(Courier::CompositePath const & value) { mCompositePath = value; }
        ::Courier::ItemId const & GetItemId() const { return mItemId; }
        void SetItemId(::Courier::ItemId const & value) { mItemId = value; }

#if defined COURIER_MESSAGE_SERIALIZATION_ENABLED
        virtual const ::Courier::SerializationInfo * GetSerializationInfo() const;
#endif
    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mWidgetMsgBaseMetaData;
        static ::Courier::Message::ModifiableMetadata mWidgetMsgBaseModifiableMetadata;
        static const ::Courier::ComponentId mWidgetMsgBaseSubscriberList[];

        ::Courier::ViewId mViewId;
        Courier::CompositePath mCompositePath;
        ::Courier::ItemId mItemId;
};

/// @}
} // namespace Courier
namespace Courier {
    struct CanderaTouchInfoConverter
    {
        static Candera::TouchInfo::State Convert(Courier::TouchMsgState::Enum touchMsgState)
        {
            Candera::TouchInfo::State state = Candera::TouchInfo::Move;
            switch (touchMsgState) {
                case Courier::TouchMsgState::Move:
                    state = Candera::TouchInfo::Move;
                    break;
                case Courier::TouchMsgState::Down:
                    state = Candera::TouchInfo::Down;
                    break;
                case Courier::TouchMsgState::Up:
                    state = Candera::TouchInfo::Up;
                    break;
                case Courier::TouchMsgState::Hover:
                    state = Candera::TouchInfo::Hover;
                    break;
            }
            return state;
        }
    };
} // namespace Courier

#endif // Courier_VisualizationMsgs_h
