//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(Courier_Visualization_ViewVisitor_h)
#define Courier_Visualization_ViewVisitor_h

#include <Courier/Base.h>
#include <Candera/Candera.h>

namespace Courier {
    class ViewScene2D;
    class ViewScene3D;
    class ViewContainer;
}

namespace Courier {
/// @addtogroup COURIER_VISUALIZATION
/// @{
/** ViewVisitor might be used for visiting all Views inside the View tree.
    Therefore an own Visitor class must be derived from this class and methods
    have to be overwritten which implements certain functionality.
    This allows customizing the behaviour of some functionality. e.g setting a
    Visitor object using SetFinalizeRenderVisitor method of ViewHandler.
*/

class ViewVisitor
{
    public:
        ///
        ViewVisitor() {};

        ///
        virtual ~ViewVisitor() {};

        /** This method is called before visiting of Views starts.
            @return <em>true</em> if visting shall be started,
                    <em>false</em> otherwise. */
        virtual bool OnBegin() = 0;

        /** Is called when a ViewContainer is visited.
            @return <em>true</em> if visting of its child views shall be executed,
                    <em>false</em> otherwise. */
        virtual bool Visit(ViewContainer * viewContainer) = 0;

#if defined(CANDERA_2D_ENABLED)
        /// Is called when a ViewScene2D is visited.
        virtual void Visit(ViewScene2D * view) = 0;
#endif

#if defined(CANDERA_3D_ENABLED)
        /// Is called when a ViewScene3D is visited.
        virtual void Visit(ViewScene3D * view) = 0;
#endif
        /// This method is called when visiting of Views ends.
        virtual void OnEnd() = 0;

    private:
        FEATSTD_MAKE_CLASS_UNCOPYABLE(ViewVisitor);
};

/// @}
}

#endif
