//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(Courier_Visualization_ViewScene3D_h)
#define Courier_Visualization_ViewScene3D_h

#include <Courier/Visualization/ViewScene.h>
#include <Courier/Util/Vector.h>
#include <Courier/Visualization/ViewContextTraverser.h>

#if defined(CANDERA_3D_ENABLED)

#include <CanderaPlatform/Device/Common/Base/RenderTarget3D.h>

#include <Courier/Visualization/ViewSceneTraverser.h>
#include <CanderaAssetLoader/AssetLoader3D/SceneContext.h>
#include <Courier/Visualization/ClearingData.h>
#include <Candera/System/Container/Map.h>

namespace Candera {
    class SceneContext;
}

namespace Courier { namespace UnitTest {
    class ViewScene3DWrapper;
}}

namespace Courier {

    class Renderer;

    /// @addtogroup COURIER_VISUALIZATION
    /// @{
    /** A ViewScene3D is a specialized View which represents one Candera 3D Scene.
    */
    class ViewScene3D : public ViewScene
    {
        friend class  Courier::UnitTest::ViewScene3DWrapper;
        friend class CameraGroupHandler;
        typedef ViewScene Base;

    public:
        /// The function prototype for detecting a touched 3D widget.
        typedef FrameworkWidget * (*GetTouchedWidget3DFct)(ViewScene3D * view3D, const TouchInfo & info);

        ///
        typedef Courier::Vector< Candera::Camera* > CameraPtrVector;
        /// Used for fast search and reverse search
        typedef Candera::Internal::Map<ItemId, Candera::Camera*> ItemIdToCameraMap;
        typedef Candera::Internal::Map<Candera::Camera*, ItemId> CameraToItemIdMap;

        ///
        ViewScene3D(bool managed = false);

        ///
        virtual ~ViewScene3D();

         /** Activates / deactivates the view for message receiving, regardless of their rendering state.
         Consecutive calls with the same value for param activate will not be taken into account.*/
        virtual void Activate(bool activate);

        /** Enables /Disables rendering for the current ViewScene2D and all its associated cameras.
        Consecutive calls with same value for param enable will not be taken into account.*/
        virtual void EnableRendering(bool enable);

        ///
        virtual void Finalize();

        ///
        virtual bool InitContent(bool init);

        ///
        virtual bool LoadContent(bool load, bool forceUpload);

        /** */
        virtual bool PartialLoad(bool forceUpload);

        /** */
        virtual bool AsyncLoadContent(bool loadContent, bool forceUpload);

        ///
        virtual bool IsContentInitialized() const;

        ///
        virtual bool IsContentLoaded() const;

        ///
        virtual void Accept(ViewVisitor & visitor);

        ///
        virtual bool GetRenderTargetPtrVector(RTPtrVector & vector, bool clear);

        ///
        virtual bool GetRenderTargetPtrVector(RTPtrVector & vector);

        ///
        virtual ViewScene3D* ToViewScene3D() { return this; }

        ///
        Candera::SceneContext * GetScene3DContext() const { return mScene3DContext; }

        ///
        ViewScene3D::CameraPtrVector & GetCameraPtrVector() { return mCameras; }

        ///
        Candera::Camera * FindCamera3D(const Char * cameraName);

        ///
        Candera::Camera * FindCamera3D(const ItemId &id);

        ///
        const ViewScene3D::CameraPtrVector & GetCameraPtrVector() const
        {
            return mCameras;
        }

        ///
        FEATSTD_LINT_NEXT_EXPRESSION(1735,"Default argument on virtual function matches the base-class argument it overrides. (See View.h)")
        virtual void Invalidate(const FeatStd::Optional<Candera::Rectangle>& dirtyArea = FeatStd::Optional<Candera::Rectangle>())
        {
            Invalidate(View::cDefaultRender3DCounter, dirtyArea);
        }

        ///
        FEATSTD_LINT_NEXT_EXPRESSION(1735,"Default argument on virtual function matches the base-class argument it overrides. (See View.h)")
        virtual void Invalidate(UInt8 renderCounter, const FeatStd::Optional<Candera::Rectangle>& dirtyArea = FeatStd::Optional<Candera::Rectangle>());

        ///
        FEATSTD_LINT_NEXT_EXPRESSION(1411, "the hidden virtual Invalidate is unlikely to be mistaken with the other Invalidate functions (receiving different parameter types but having the same purpose)")
        FEATSTD_LINT_NEXT_EXPRESSION(1735,"Virtual function does not override a base-class function.")
        virtual void Invalidate(Candera::Camera * camera, const FeatStd::Optional<Candera::Rectangle>& dirtyArea = FeatStd::Optional<Candera::Rectangle>())
        {
            Invalidate(camera, View::cDefaultRender3DCounter, dirtyArea);
        }

        ///
        FEATSTD_LINT_NEXT_EXPRESSION(1411, "the hidden virtual Invalidate is unlikely to be mistaken with the other Invalidate functions (receiving different parameter types but having the same purpose)")
        FEATSTD_LINT_NEXT_EXPRESSION(1735,"Virtual function does not override a base-class function.")
        virtual void Invalidate(Candera::Camera * camera, UInt8 renderCounter, const FeatStd::Optional<Candera::Rectangle>& dirtyArea = FeatStd::Optional<Candera::Rectangle>());

        ///
        FEATSTD_LINT_NEXT_EXPRESSION(1735,"Default argument on virtual function matches the base-class argument it overrides. (See View.h)")
        virtual void Invalidate(Candera::RenderTarget * renderTarget, const FeatStd::Optional<Candera::Rectangle>& dirtyArea = FeatStd::Optional<Candera::Rectangle>());

        ///
        FEATSTD_LINT_NEXT_EXPRESSION(1735,"Default argument on virtual function matches the base-class argument it overrides. (See View.h)")
        virtual void InvalidateOffscreenHelper(const FeatStd::Optional<Candera::Rectangle>& dirtyArea = FeatStd::Optional<Candera::Rectangle>());

        ///
        FEATSTD_LINT_NEXT_EXPRESSION(1735,"Default argument on virtual function matches the base-class argument it overrides. (See View.h)")
        virtual void Clear(bool onlyCameraViewPorts, const FeatStd::Optional<Candera::Rectangle>& dirtyArea = FeatStd::Optional<Candera::Rectangle>());

        ///
        virtual FrameworkWidget * GetTouchedWidget(const TouchInfo & info);

        ///
        virtual Candera::MemoryManagement::SharedPointer<Candera::Animation::AnimationPlayerBase> GetAnimation(const CompositePath & compositePath, const ItemId & animationId);

        /// Allow setting an own implementation of the GetTouchedWidget3DFct.
        static void SetTouchedWidget3DFunction(GetTouchedWidget3DFct fct)
        {
            mGetTouchedWidget3DFunction = fct;
        }

        COURIER_DEPRECATED_MSG("DEPRECATED! - Please use UploadNode2DTraverserSet member method instead")
            static void SetUploadNodeTraverser(UploadNodeTraverser *){};

        /// Allow using an own implementation of an UploadNodeTraverser by overwritten the method UploadNodeTraverser::ProcessNode.
        void UploadNodeTraverserSet(UploadNodeTraverser * uploadNodeTraverser) { mCurrentUploadNodeTraverser = uploadNodeTraverser;}

    protected:
        ///
        virtual void InitCameras();

        ///
        virtual void EnableRendertargets(bool enable, bool forceUpload);

        ///
        virtual void FillWidgetList();

        /// Releases the 3D scene context.
        virtual void ReleaseSceneContext();

        /// Actual implementation for Activate method.
        virtual void ActivateImpl(bool activate);

        /// Actual implementation for EnableRendering method.
        virtual void EnableRenderingImpl(bool enable);

        /// Sets the rendering state for the actual scene from Candera.
        virtual void EnableRenderingScene(bool enable);

        /// Sets the rendering state for the actual camera from Candera.
        virtual void UpdateCameraRenderingState(bool enable, Candera::CanderaObject* camera);

        virtual void InitClearingData3D(const Gdu* gdu);

        virtual void UpdateClearingData3D();

    private:
        /// Helper method for detecting cameras and filling camera vector.
        void DetectCamera(Candera::Node * node);

        ///
        void DeleteRenderJobs();

        ///
        bool BuildScene3DContextAsync();

        ///
        void FinishInitContent();

        /// The 3D scene context
        Candera::SceneContext * mScene3DContext;

        /// 3D camera list
        CameraPtrVector mCameras;
        /// Bi-directional map from camera to ItemId, for fast search and reverse search
        CameraToItemIdMap mCameraToId;
        ItemIdToCameraMap mIdToCamera;

        /// Current asset build state
        Candera::ContentLoader::BuildState mBuildState;

        /** Default implementation for detecting a touched widget.
        This function might by exchanged using SetTouchedWidget3DFunction.
        The function shall return a pointer of the FrameworkWidget if it is considered to be touched.*/
        static FrameworkWidget * GetTouchedWidget3D(ViewScene3D * view3D, const TouchInfo & info);

        /// The function pointer of the GetTouchedWidget3DFct function.
        static GetTouchedWidget3DFct mGetTouchedWidget3DFunction;

        Candera::ContentLoader::AsyncBuildState::SharedPointer mPartialLoadAsyncRequest;

        /// Current State used for Async Loading
        ViewScene::LoadState mPartialLoadState;
        /// Number of calls needed
        UInt32 mPartialLoadCalls;
        /// Traverser for uploading purposes
        UploadNodeTraverser mUploadTraverser;
        /// Current UploadNodeTraverser which is used.
        UploadNodeTraverser * mCurrentUploadNodeTraverser;

        /// Helper methods
        void ScheduleCamera(Candera::Camera* camera, Courier::Renderer* renderer, const FeatStd::Optional<Candera::Rectangle>& dirtyArea, IViewHandler* viewHandler, const Courier::Gdu* gdu);

        ///
        Courier::Internal::ClearingData3DVct mClearingData3DVct;
        ///
        Candera::Internal::Map<Candera::RenderTarget*, bool> mClearingDataInitFlag;

        ///
        Courier::Internal::CameraToClearingData3D mCameraToClearingData;

        ///
        ContextTraverser<Candera::Camera, Candera::Scene, Candera::SceneContext, UploadNodeTraverser> m_contextTraverser;

        /// Helper method
        void CleanUp();

        FEATSTD_MAKE_CLASS_UNCOPYABLE(ViewScene3D);
    };

    /// @}
}

#endif

#endif
