//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(Courier_Visualization_ViewScene2D_h)
#define Courier_Visualization_ViewScene2D_h

#include <Courier/Visualization/ViewScene.h>
#include <Courier/Util/Vector.h>

#if defined(CANDERA_2D_ENABLED)

#include <CanderaPlatform/Device/Common/Base/RenderTarget2D.h>

#include <Courier/Visualization/ViewSceneTraverser.h>
#include <CanderaAssetLoader/AssetLoader2D/Scene2DContext.h>
#include <Courier/Visualization/ClearingData.h>
#include <Candera/System/Container/Map.h>
#include <Courier/Visualization/ViewContextTraverser.h>

namespace Candera {
    class Scene2DContext;
}

namespace Courier { namespace UnitTest {
        class ViewScene2DWrapper;
}}

namespace Courier {

    class Renderer;

    /// @addtogroup COURIER_VISUALIZATION
    // @{
    /** A ViewScene2D is a specialized View which represents one Candera 2D Scene.
    */
    class ViewScene2D : public ViewScene
    {
        friend class Courier::UnitTest::ViewScene2DWrapper;
        friend class CameraGroupHandler;
        typedef ViewScene Base;

    public:
        /// The function prototype for detecting a touched 2D widget.
        typedef FrameworkWidget * (*GetTouchedWidget2DFct)(ViewScene2D * view2D, const TouchInfo & info);

        ///
        typedef Courier::Vector< Candera::Camera2D* > CameraPtrVector;
        // Used for fast search and reverse search
        typedef Candera::Internal::Map<ItemId, Candera::Camera2D*> ItemIdToCameraMap;
        typedef Candera::Internal::Map<Candera::Camera2D*, ItemId> CameraToItemIdMap;

        ///
        ViewScene2D(bool managed = false);

        ///
        virtual ~ViewScene2D();

         /** Activates / deactivates the view for message receiving, regardless of their rendering state.
         Consecutive calls with the same value for param activate will not be taken into account.*/
        virtual void Activate(bool activate);

        /** Enables /Disables rendering for the current ViewScene2D and all its associated cameras.
        Consecutive calls with same value for param enable will not be taken into account.*/
        virtual void EnableRendering(bool enable);

        ///
        virtual void Finalize();

        ///
        virtual bool InitContent(bool init);

        ///
        virtual bool LoadContent(bool load, bool forceUpload);

        /** */
        virtual bool PartialLoad(bool forceUpload);

        /** */
        virtual bool AsyncLoadContent(bool loadContent, bool forceUpload);

        ///
        virtual bool IsContentInitialized() const;

        ///
        virtual bool IsContentLoaded() const;

        ///
        virtual void Accept(ViewVisitor & visitor);

        ///
        virtual bool GetRenderTargetPtrVector(RTPtrVector & vector, bool clear);

        ///
        virtual bool GetRenderTargetPtrVector(RTPtrVector & vector);

        ///
        virtual ViewScene2D* ToViewScene2D() { return this; }

        ///
        Candera::Scene2DContext * GetScene2DContext() const { return mScene2DContext; }

        ///
        ViewScene2D::CameraPtrVector & GetCameraPtrVector() { return mCameras; }

        ///
        Candera::Camera2D * FindCamera2D(const Char * cameraName);

        ///
        Candera::Camera2D * FindCamera2D(const ItemId &id);

        ///
        const ViewScene2D::CameraPtrVector & GetCameraPtrVector() const
        {
            return mCameras;
        }

        ///
        FEATSTD_LINT_NEXT_EXPRESSION(1735,"Default argument on virtual function matches the base-class argument it overrides. (See View.h)")
        virtual void Invalidate(const FeatStd::Optional<Candera::Rectangle>& dirtyArea = FeatStd::Optional<Candera::Rectangle>())
        {
            Invalidate(View::cDefaultRender2DCounter, dirtyArea);
        }

        ///
        FEATSTD_LINT_NEXT_EXPRESSION(1735,"Default argument on virtual function matches the base-class argument it overrides. (See View.h)")
        virtual void Invalidate(UInt8 renderCounter, const FeatStd::Optional<Candera::Rectangle>& dirtyArea = FeatStd::Optional<Candera::Rectangle>());

        ///
        FEATSTD_LINT_NEXT_EXPRESSION(1411, "the hidden virtual Invalidate is unlikely to be mistaken with the other Invalidate functions (receiving different parameter types but having the same purpose)")
        FEATSTD_LINT_NEXT_EXPRESSION(1735,"Virtual function does not override a base-class function.")
        virtual void Invalidate(Candera::Camera2D * camera, const FeatStd::Optional<Candera::Rectangle>& dirtyArea = FeatStd::Optional<Candera::Rectangle>())
        {
            Invalidate(camera, View::cDefaultRender2DCounter, dirtyArea);
        }

        ///
        FEATSTD_LINT_NEXT_EXPRESSION(1411, "the hidden virtual Invalidate is unlikely to be mistaken with the other Invalidate functions (receiving different parameter types but having the same purpose)")
        FEATSTD_LINT_NEXT_EXPRESSION(1735,"Virtual function does not override a base-class function.")
        virtual void Invalidate(Candera::Camera2D * camera, UInt8 renderCounter, const FeatStd::Optional<Candera::Rectangle>& dirtyArea = FeatStd::Optional<Candera::Rectangle>());

        ///
        FEATSTD_LINT_NEXT_EXPRESSION(1735,"Default argument on virtual function matches the base-class argument it overrides. (See View.h)")
        virtual void Invalidate(Candera::RenderTarget * renderTarget, const FeatStd::Optional<Candera::Rectangle>& dirtyArea = FeatStd::Optional<Candera::Rectangle>());

        ///
        FEATSTD_LINT_NEXT_EXPRESSION(1735,"Default argument on virtual function matches the base-class argument it overrides. (See View.h)")
        virtual void InvalidateOffscreenHelper(const FeatStd::Optional<Candera::Rectangle>& dirtyArea = FeatStd::Optional<Candera::Rectangle>());

        ///
        FEATSTD_LINT_NEXT_EXPRESSION(1735,"Default argument on virtual function matches the base-class argument it overrides. (See View.h)")
        virtual void Clear(bool onlyCameraViewPorts, const FeatStd::Optional<Candera::Rectangle>& dirtyArea = FeatStd::Optional<Candera::Rectangle>());

        ///
        virtual FrameworkWidget * GetTouchedWidget(const TouchInfo & info);

        ///
        virtual Candera::MemoryManagement::SharedPointer<Candera::Animation::AnimationPlayerBase> GetAnimation(const CompositePath & compositePath, const ItemId & animationId);

        /// Allow setting an own implementation of the GetTouchedWidget2DFct.
        static void SetTouchedWidget2DFunction(GetTouchedWidget2DFct fct)
        {
            mGetTouchedWidget2DFunction = fct;
        }

        COURIER_DEPRECATED_MSG("DEPRECATED! - Please use UploadNode2DTraverserSet member method instead")
        static void SetUploadNode2DTraverser(UploadNode2DTraverser *) {};

        /// Allow using an own implementation of an UploadNode2DTraverser by overwritten the method UploadNode2DTraverser::ProcessNode.
        void UploadNode2DTraverserSet(UploadNode2DTraverser * uploadNode2DTraverser) { mCurrentUploadNodeTraverser = uploadNode2DTraverser;}

    protected:
        ///
        virtual void InitCameras();

        ///
        virtual void EnableRendertargets(bool enable, bool forceUpload);

        ///
        virtual void FillWidgetList();

        /// Releases the 2D scene context.
        virtual void ReleaseSceneContext();

        /// Actual implementation for Activate method.
        virtual void ActivateImpl(bool activate);

        /// Actual implementation for EnableRendering method.
        virtual void EnableRenderingImpl(bool enable);

        /// Sets the rendering state for the actual scene from Candera.
        virtual void EnableRenderingScene(bool enable);

        /// Sets the rendering state for the actual camera from Candera.
        virtual void UpdateCameraRenderingState(bool enable, Candera::CanderaObject* camera);

        virtual void InitClearingData2D(const Gdu* gdu);

        virtual void UpdateClearingData2D();

    private:
        /// Helper method for detecting cameras and filling camera vector.
        void DetectCamera(Candera::Node2D * node);

        /// Lookup surface handle for automatic invalidation
        void LookupSurfaceHandle(const Candera::Node2D * node);

        ///
        void DeleteRenderJobs();

        ///
        bool BuildScene2DContextAsync();

        ///
        void FinishInitContent();

        /// The 2D scene context
        Candera::Scene2DContext * mScene2DContext;

        /// 2D camera list
        CameraPtrVector mCameras;
        /// Bi-directional map from camera to ItemId, for fast search and reverse search
        CameraToItemIdMap mCameraToId;
        ItemIdToCameraMap mIdToCamera;

        /// Current asset build state
        Candera::ContentLoader::BuildState mBuildState;

        /** Default implementation for detecting a touched widget.
        This function might by exchanged using SetTouchedWidget2DFunction.
        The function shall return a pointer of the FrameworkWidget if it is considered to be touched.*/
        static FrameworkWidget * GetTouchedWidget2D(ViewScene2D * view2D, const TouchInfo & info);

        /// The function pointer of the GetTouchedWidget2DFct function.
        static GetTouchedWidget2DFct mGetTouchedWidget2DFunction;

        Candera::ContentLoader::AsyncBuildState::SharedPointer mPartialLoadAsyncRequest;

        /// Current State used for Async Loading
        ViewScene::LoadState mPartialLoadState;
        /// Number of calls needed
        FeatStd::SizeType mPartialLoadCalls;
        /// Traverser for uploading purposes
        UploadNode2DTraverser mUploadTraverser;
        /// Current UploadNode2DTraverser which is used.
        UploadNode2DTraverser* mCurrentUploadNodeTraverser;

        /// Helper methods
        void ScheduleCamera(Candera::Camera2D* camera, Courier::Renderer* renderer, const FeatStd::Optional<Candera::Rectangle>& dirtyArea, IViewHandler* viewHandler, const Courier::Gdu* gdu);

        ///
        Courier::Internal::ClearingData2DVct mClearingData2DVct;
        ///
        Candera::Internal::Map<Candera::RenderTarget*, bool> mClearingDataInitFlag;

        ///
        Courier::Internal::CameraToClearingData2D mCameraToClearingData;

        ///
        ContextTraverser<Candera::Camera2D, Candera::Scene2D, Candera::Scene2DContext, UploadNode2DTraverser, /* Is2D*/ true> m_contextTraverser;

        /// Helper method for gathering members cleaning code
        void CleanUp();

        FEATSTD_MAKE_CLASS_UNCOPYABLE(ViewScene2D);
    };

    /// @}
}

#endif

#endif
