//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(Courier_Visualization_ViewPlaceholder_h)
#define Courier_Visualization_ViewPlaceholder_h

#include <Courier/Visualization/View.h>
#include <Courier/Visualization/Renderer.h>

namespace Courier {
    /// @addtogroup COURIER_VISUALIZATION
    /// @{

    enum ViewPlaceholderLoadError {
        /// Successful action
        ViewPlaceholderSuccess,

        /// ViewPlaceholder is already loaded
        ViewPlaceholderAlreadyLoaded,

        /// ViewPlaceholder not loaded
        ViewPlaceholderNotLoaded,

        // Other error
        NoViewForViewPlaceholder

    };

    namespace Internal {
        /** ViewPlaceholder is a placeholder class for View objects which controls the loading/unloading of the render targets associated with the cameras of the view.
        */
        class ViewPlaceholder
        {
        public:
            // Constructor
            ViewPlaceholder():
                mRenderTargetVct(),
                mViewId(){}

            /** Calls an upload on the render targets associated with the cameras of the view. This upload call increases the ref count of the render targets.
            @param view View pointer for which the render targets must be controlled
            @param renderer the Renderer pointer
            @return <em>true</em> if uploading was successful,
                    <em>false</em> otherwise. */
            bool Upload(View* view, Renderer* renderer);

            /** Calls an unload on the previously uploaded render targets, which decreases their ref count.
            @param renderer the Renderer pointer
            @return <em>true</em> if unloading was successful,
                    <em>false</em> otherwise. */
            bool Unload(Renderer* renderer);

            const ViewId& GetViewId() const { return mViewId; }

        private:
            RTPtrVector mRenderTargetVct;
            ViewId mViewId;

        };

        /// @}
    } // Internal namespace
} // Courier namespace

#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
namespace FeatStd {
    template<> ::FeatStd::UInt32 StringBufferAppender< ::Courier::ViewPlaceholderLoadError >::Append(::FeatStd::StringBuffer& stringBuffer, ::Courier::ViewPlaceholderLoadError const & object);
}
#endif
#endif //Courier_Visualization_ViewPlaceholder_h
