//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "ViewPlaceholder.h"
#include <Courier/Visualization/Gdu.h>
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
#include <FeatStd/Util/StringBuffer.h>
#endif

namespace Courier { namespace Internal {

    // ------------------------------------------------------------------------
    bool ViewPlaceholder::Upload(View* view, Renderer* renderer)
    {
        bool result = false;
        if ((0 !=  view) && (0 != renderer)){
            mViewId = view->GetId();
            if (view->GetRenderTargetPtrVector(mRenderTargetVct)) {
                for (FeatStd::SizeType i = 0; i < mRenderTargetVct.Size(); ++i) {
                    Gdu* gdu = renderer->GetGdu(mRenderTargetVct[i]);
                    if ((0 != gdu) && (gdu->IsLoaded())) {
                        // this method handles the ref count for render target
                        renderer->EnableLayer(true, mRenderTargetVct[i], true);
                    }
                }
                result = true;
            }
        }
        return result;
    }

    // ------------------------------------------------------------------------
    bool ViewPlaceholder::Unload(Renderer* renderer)
    {
        bool result = false;
        if (0 != renderer) {
            for (FeatStd::SizeType i = 0; i < mRenderTargetVct.Size(); ++i) {
                Gdu* gdu = renderer->GetGdu(mRenderTargetVct[i]);
                if ((0 != gdu) && (gdu->IsLoaded())) {
                    // this method handles the ref count for render target
                    renderer->EnableLayer(false, mRenderTargetVct[i], true);
                }
            }
            result = true;
        }
        return result;
    }
}}

#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
namespace FeatStd {
template<> ::FeatStd::UInt32 StringBufferAppender< ::Courier::ViewPlaceholderLoadError >::Append(::FeatStd::StringBuffer& stringBuffer, ::Courier::ViewPlaceholderLoadError const & object)
{
    ::FeatStd::UInt32 tcharCount = 0;
    switch (object) {
        case ::Courier::ViewPlaceholderSuccess:
            tcharCount += stringBuffer.Append("::Courier::ViewPlaceholderLoadError::ViewPlaceholderSuccess");
            break;
        case ::Courier::ViewPlaceholderAlreadyLoaded:
            tcharCount += stringBuffer.Append("::Courier::ViewPlaceholderLoadError::ViewPlaceholderAlreadyLoaded");
            break;
        case ::Courier::ViewPlaceholderNotLoaded:
            tcharCount += stringBuffer.Append("::Courier::ViewPlaceholderLoadError::ViewPlaceholderNotLoaded");
            break;
        case ::Courier::NoViewForViewPlaceholder:
            tcharCount += stringBuffer.Append("::Courier::ViewPlaceholderLoadError::NoViewForViewPlaceholder");
            break;
        default:
            tcharCount += stringBuffer.Append("##unknown##");
            break;
    }
    return tcharCount;
}
}

#endif
