//########################################################################
// (C) Candera GmbH
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Candera GmbH.
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "ViewId.h"
#include <CanderaPlatform/OS/StringPlatform.h>
#include <Courier/Diagnostics/ErrorHandling.h>

namespace Courier {
// ------------------------------------------------------------------------
ViewId::ViewId() : mId(""), mHashId(""), mViewNameCopied(false)
{
}

// ------------------------------------------------------------------------
ViewId::ViewId(const Char * viewName, bool createCopyOfViewName) : mHashId(viewName), mViewNameCopied(false)
{
    FEATSTD_PANIC_IF(viewName==0,"string pointer zero !");
    if (!createCopyOfViewName) {
        mId = viewName;
    } else {
        Char * temp = FEATSTD_NEW_ARRAY(Char, Candera::StringPlatform::Length(viewName) + 1);
        if (0 == temp) {
            mId = "";
            FEATSTD_PANIC_IF(temp==0, "allocation for View Name copy failed");
        } else {
            mViewNameCopied = true;
            Candera::StringPlatform::Copy(temp, viewName);
            mId = temp;
        }
    }
}

// ------------------------------------------------------------------------
FEATSTD_LINT_NEXT_EXPRESSION(1554, "we want to copy the pointer")
ViewId::ViewId(const ViewId & viewId) : mId(viewId.mId), mHashId(viewId.mHashId), mViewNameCopied(viewId.mViewNameCopied)
{
}

ViewId::~ViewId()
{
    if (mViewNameCopied) {
        FEATSTD_DELETE_ARRAY(mId);
    }
}
}

#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
namespace FeatStd {

template<> UInt32 StringBufferAppender<Courier::ViewId>::Append(StringBuffer& stringBuffer, Courier::ViewId const & object)
{
    UInt32 tcharCount = 0;
    tcharCount += stringBuffer.Append("Courier::ViewId { name = ");
    tcharCount += stringBuffer.AppendObject(object.CStr());
    if (0 != object.CStr()) {
        tcharCount += stringBuffer.Append(", hash = ");
        tcharCount += stringBuffer.AppendObject(object.GetHashId().HashValue());
    }
    tcharCount += stringBuffer.Append(" }");
    return tcharCount;
}

}
#endif
