//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(Courier_Visualization_ViewHandlerSession_h)
#define Courier_Visualization_ViewHandlerSession_h

#include <Courier/Base.h>

namespace Courier {
    class Message;
    class IViewHandler;
}

namespace Courier { 
/// @addtogroup COURIER_VISUALIZATION
/// @{
/**
*/
class ViewHandlerSession
{
    public:
        ///
        ViewHandlerSession() : mViewHandler(0) {};

        ///
        virtual ~ViewHandlerSession() { mViewHandler = 0; };

        /** Initializes the ViewHandlerSession.
            @param viewHandler IViewHandler used for rendering and message distribution. 
            @return <em>true</em> if initialization was successful,
                    <em>false</em> otherwise. */
        bool Init(IViewHandler * viewHandler) {
            FEATSTD_DEBUG_ASSERT(viewHandler!=0);
            mViewHandler = viewHandler;
            return (mViewHandler!=0);
        }

        ///
        virtual bool ProcessMessage(const Message & msg) = 0;

        ///
        virtual bool IsSessionStarted() const = 0;

        /// IViewHandler access method. 
        IViewHandler * GetViewHandler() { 
            return mViewHandler; 
        }

    private:
        /// The used ViewHandler.
        IViewHandler * mViewHandler;
       
};

/// @}

}

#endif
