//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "ViewFactory.h"

#include "IViewHandler.h"
#include "ViewScene2D.h"
#include "ViewScene3D.h"
#include "ViewContainer.h"
#include <Courier/Platform/Memory.h>
#include <Courier/Diagnostics/Log.h>

namespace Courier {

    COURIER_LOG_SET_REALM(Courier::Diagnostics::LogRealm::Visualization);

// ------------------------------------------------------------------------
ViewFactory::ViewFactory() : mViewHandler(0)
{
}

// ------------------------------------------------------------------------
ViewFactory::~ViewFactory()
{
    mViewHandler = 0;
}

// ------------------------------------------------------------------------
View * ViewFactory::Create(const ViewId & viewId)
{
    return Create(viewId.CStr());
}

// ------------------------------------------------------------------------
View * ViewFactory::Create(const Char * viewId)
{
    COURIER_UNUSED(viewId);
    COURIER_LOG_DEBUG("By default this returns 0. For specific behaviour, classes derived from ViewFactory must override this virtual method.");
    return 0;
}

// ------------------------------------------------------------------------
void ViewFactory::Destroy(View * view)
{
    COURIER_UNUSED(view);
    COURIER_LOG_DEBUG("By default this does nothing. For specific behaviour, classes derived from ViewFactory must override this virtual method.");
}

// ------------------------------------------------------------------------
ViewScene * ViewFactory::CreateViewScene(bool is2D)
{
    ViewScene * view = 0;
    if(is2D) {
#if defined(CANDERA_2D_ENABLED)
        view = FEATSTD_NEW(ViewScene2D)(true);
#endif
    } else {
#if defined(CANDERA_3D_ENABLED)
        view = FEATSTD_NEW(ViewScene3D)(true);
#endif
    }
    return view;
}

// ------------------------------------------------------------------------
ViewContainer * ViewFactory::CreateViewContainer()
{
    ViewContainer * container = FEATSTD_NEW(ViewContainer)(true);
    return container;
}

// ------------------------------------------------------------------------
void ViewFactory::DestroyView(View * view)
{
    FEATSTD_DEBUG_ASSERT(view!=0);
    FEATSTD_DELETE(view);
}
}
