//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "ViewComponent.h"

#include <Courier/DataBinding/DataBindingMsg.h>

namespace Courier {

// ------------------------------------------------------------------------
ViewComponent::ViewComponent() : Component(ComponentId(ComponentType::View))
{
}

// ------------------------------------------------------------------------
ViewComponent::~ViewComponent()
{
}

// ------------------------------------------------------------------------
bool ViewComponent::Init(IViewHandler * viewHandler)
{
    return mViewFacade.Init(viewHandler);
}

// ------------------------------------------------------------------------
bool ViewComponent::OnExecute()
{
    return mViewFacade.PartialLoad();
}

// ------------------------------------------------------------------------
bool ViewComponent::OnMessage(const Message & msg)
{
    AcquireDataLock();
    bool lRc = mViewFacade.OnViewComponentMessage(msg);
    ReleaseDataLock();
    return lRc;
}

}
