//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(Courier_Visualization_ViewAccessor_h)
#define Courier_Visualization_ViewAccessor_h

#include <Courier/Util/HashId.h>
#include <Courier/Visualization/View.h>

namespace Courier {
    namespace UnitTest {
        class ViewAccessorWrapper;
    }
}

namespace Courier { 

/// @addtogroup COURIER_VISUALIZATION
/// @{
/** 
*/
class ViewAccessor 
{
    private:
        friend class Courier::UnitTest::ViewAccessorWrapper;

        class Item 
        {
            public:
                ///
                Item() : mView(0) {}

                ///
                explicit Item(const View * view) : mView(view), mHashId(view->GetId().CStr()) {}

                ///
                Item(const View * view, const HashId & hashId) : mView(view), mHashId(hashId) {}

                ///
                Item(const Item & item) : mView(item.mView), mHashId(item.mHashId) {}

                ///
                Item & operator = (const Item & item) {
                    if (this!=&item) {
                        FEATSTD_LINT_SYMBOL(1555, Courier::ViewAccessor::Item::mView, It is direct copy of pointer but it points to const.);
                        mView = item.mView;
                        mHashId = item.mHashId;
                    }
                    return *this;
                }

                ///
                bool operator==(const Item & item) const {
                    return item.mHashId==mHashId;
                }
                ///
                bool operator!=(const Item & item) const {
                    return item.mHashId!=mHashId;
                }
                ///
                bool operator>(const Item & item) const {
                    return mHashId > item.mHashId;
                }
                ///
                bool operator<(const Item & item) const {
                    return mHashId < item.mHashId;
                }
                ///
                const View * GetView() const {
                    return mView;
                }
                ///
                const HashId GetHashId() const {
                    return mHashId;
                }

            private:
                ///
                const View * mView;
                ///
                HashId mHashId;
        };        

        ///
        typedef Vector< Item > ItemVector;

    public:
        ///
        ViewAccessor();
        /// 
        virtual ~ViewAccessor();
        ///
        void Finalize();
        ///
        bool AddItem(const View * view);
        ///
        bool RemoveItem(const View * view);
        ///
        const View * Lookup(const HashId & hashId) const;
        ///
        FeatStd::SizeType GetViewCount() const { return mItemVector.Size(); }
        ///
        bool AssertValid() const;
        ///
        void GetEnabledViewSceneVector(bool is2D, ViewPtrVector & viewVector);

    private:
        ///
        FeatStd::OffsetType LookupPos(const HashId & hashId) const;
        ///
        ItemVector mItemVector;        
};

/// @}
}

#endif
