//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(Courier_Visualization_RenderHint_h)
#define Courier_Visualization_RenderHint_h

#include <Courier/Visualization/View.h>

// ----------------------------------------------------------------------------
namespace Courier { 
/// @addtogroup COURIER_VISUALIZATION
/// @{
/** 
*/
class RenderHint 
{
    public:
        virtual bool ShallRender2D() = 0;
        virtual bool ShallRender3D() = 0;
};

class RenderHintAll : public RenderHint 
{
    public:
        virtual bool ShallRender2D() { return true; }
        virtual bool ShallRender3D() { return true; }
};

class RenderHint2D : public RenderHint 
{
    public:
        virtual bool ShallRender2D() { return true; }
        virtual bool ShallRender3D() { return false; }
};

class RenderHint3D : public RenderHint 
{
    public:
        virtual bool ShallRender2D() { return false; }
        virtual bool ShallRender3D() { return true; }
};

/// @}
}

#endif
