//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "ItemId.h"
#include <Courier/Diagnostics/ErrorHandling.h>

namespace Courier {

// ------------------------------------------------------------------------
ItemId::ItemId() : mId(""), mHashId("")
{
}

// ------------------------------------------------------------------------
ItemId::ItemId(const Char * itemString) : mId(itemString), mHashId(itemString)
{
    FEATSTD_PANIC_IF(itemString==0,"string pointer zero !");
}

// ------------------------------------------------------------------------
FEATSTD_LINT_NEXT_EXPRESSION(1554, "we want to copy the pointer")

ItemId::ItemId(const ItemId & itemId) : mId(itemId.mId), mHashId(itemId.mHashId)
{
}

}

#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
namespace FeatStd {

template<> UInt32 StringBufferAppender<Courier::ItemId>::Append(StringBuffer& stringBuffer, Courier::ItemId const & object)
{
    UInt32 tcharCount = 0;
    tcharCount += stringBuffer.Append("Courier::ItemId { name = ");
    tcharCount += stringBuffer.AppendObject(object.CStr());
    if (0 != object.CStr()) {
        tcharCount += stringBuffer.Append(", hash = ");
        tcharCount += stringBuffer.AppendObject(object.GetHashId().HashValue());
    }
    tcharCount += stringBuffer.Append(" }");
    return tcharCount;
}

}
#endif
