//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "InvalidationViews.h"

#include <Courier/Diagnostics/Log.h>
#include <Courier/Visualization/Renderer.h>



namespace Courier {
    namespace Internal {

        COURIER_LOG_SET_REALM(Courier::Diagnostics::LogRealm::Visualization);

        
        Courier::Internal::InvalidationViews& InvalidationViews::GetInstance()
        {
            FEATSTD_UNSYNCED_STATIC_OBJECT(InvalidationViews, s_invalidationViews);
            return s_invalidationViews;
        }

        FeatStd::Internal::Vector<Courier::ViewId>& InvalidationViews::Swap()
        {
#ifdef FEATSTD_THREADSAFETY_ENABLED
            FeatStd::Internal::CriticalSectionLocker lock(&m_criticalSection);
#endif
            FeatStd::SizeType current = m_current;
            m_current = (m_current + 1) % 2;
            return m_views[current];
        }

        void InvalidationViews::Add(const ViewId& viewId)
        {
#ifdef FEATSTD_THREADSAFETY_ENABLED
            FeatStd::Internal::CriticalSectionLocker lock(&m_criticalSection);
#endif
            if (!m_views[m_current].Add(viewId)) {
                FEATSTD_LOG_ERROR("Error adding view %s to the view invalidation list!", viewId.CStr());
            }
            // This line has to be analyzed. It makes sense to call a wakeup when a view has been added.
            // However, it leads to race conditions with the views.
            //Courier::Renderer::WakeUpAllRenderComponents();
        }

        bool InvalidationViews::ContainsUnhandledViews()
        {
#ifdef FEATSTD_THREADSAFETY_ENABLED
            FeatStd::Internal::CriticalSectionLocker lock(&m_criticalSection);
#endif
            return m_views[m_current].Size() != 0;
        }

    }
}
