//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(Courier_Visualization_AssertConfiguration_h)
#define Courier_Visualization_AssertConfiguration_h

#include <CanderaAssetLoader/AssetLoaderBase/AssetConfig.h>
#include <Courier/Util/Util.h>

// ----------------------------------------------------------------------------
namespace Courier {
/// @addtogroup COURIER_VISUALIZATION
/// @{
/** An AssetConfiguration represents a set of assets.
    One or more asset repositories can be added/removed to/from an asset configuration. A Candera::AssetRepository represents e.g.
    a FileAssetRepository or a MemoryAssetRepository (or any other repository which fullfills the Candera::AssetRepository interface).
    An instance of the AssetConfiguration which already has been filled with asset repositories, is used by the ViewHandler during
    the initalization phase.
*/
class AssetConfiguration : public Candera::AssetConfig
{
    public:
        ///
        AssetConfiguration();

        ///
        virtual ~AssetConfiguration();

        /** Clears the asset repository list. Does not free any memory occupied by the repositories themselves. */
        void Clear();

        /** Adds a repository to the repository configuration.
            @param repository AssetRepository to be added.
            @return <em>true</em> if the repository was added,
                    <em>false</em> otherwise. */
        bool Add(Candera::AssetRepository * repository);

        /** Removes a repository from the repository configuration.
            @param repository AssetRepository to be removed.
            @return <em>true</em> if the repository was removed,
                    <em>false</em> otherwise. */
        bool Remove(const Candera::AssetRepository * repository);

        /** Returns the repository held at position 'index'.
            Used by the asset loading mechanism of Candera.
            @param index position inside the asset configuration.
            @return <em>AssetRepository</em> a pointer to the repository at the specified position,
                    <em>0</em> otherwise. */
        virtual Candera::AssetRepository * GetAssetRepository(UInt16 index) const;

        /** Returns the number of repositories held by this asset configuration.
            Used by the asset loading mechanism of Candera.
            @return <em>1..n</em> if one or more repositories are present,
                    <em>0</em> otherwise. */
        virtual UInt16 GetAssetRepositoryCount() const;

    private:
        ///
        typedef Courier::Vector< Candera::AssetRepository * > AssetRepositoryPtrVector;
        /// The AssetRepository vector
        AssetRepositoryPtrVector mAssetRepositories;
};

/// @}
}

#endif
